/* --------------------------------------------------------------------------
 * SvgBallExample
 * --------------------------------------------------------------------------
 * prog:  Max Rheiner 
 * date:  03/1/2011 (m/d/y)
 * ----------------------------------------------------------------------------
 */

BouncingBall ball1;
BouncingBall ball2;

PVector      p1 = new PVector();
PVector      p2 = new PVector();
boolean      drag = false;

void setup()
{
  size(800,600); 

  ball1 = new BouncingBall(100,100);
  ball2 = new BouncingBall(50,50);
  
  // svg bild soll zentriert sein
  shapeMode(CENTER);
  smooth();
}

void draw()
{
  // hintergrund loeschen
  //background(255);
  // ghosting
  fill(255,255,255,60);
  rect(0,0,width,height);
    
  if(drag)
  { // zeichne die abschussrichtung
    p1.set(ball1._pos.x,ball1._pos.y,0);
    line(p1.x,p1.y,p2.x,p2.y);
  }
  
  // zeichne den ball
  ball1.draw();
  ball2.draw();
}

void mousePressed()
{
  drag = true;
  p1.set(ball1._pos.x,ball1._pos.y,0);
  p2.set(mouseX,mouseY,0);
}

void mouseDragged()
{
  p2.set(mouseX,mouseY,0);
}

void mouseReleased()
{
  drag = false;
  
  // abschuss staerke berechnen
  PVector dir = PVector.sub(p2,p1);
  // laenge verkuerzen
  dir.mult(.09);
  
  // der ball wird neu ausgerichtet
  ball1.set(p1,dir,.993);
  ball2.set(p1,dir,.95);
}

