/* --------------------------------------------------------------------------
 * BouncingBall
 * --------------------------------------------------------------------------
 * prog:  Max Rheiner 
 * date:  03/1/2011 (m/d/y)
 * ----------------------------------------------------------------------------
 */
 
class BouncingBall
{
  PVector _pos;
  PVector _dir;
  float   _dampV;
  PShape  _shape;
  int     _w;
  int     _h;
  
  // konstruktor
  BouncingBall(int shapeWidth,int shapeHeight)
  {
    _pos = new PVector(width/2, height/2);
    _dir = new PVector(0,0);
    _dampV = 1;
    
    _w = shapeWidth;
    _h = shapeHeight;
    
    _shape = loadShape("ball1.svg");
  }
  
  // setzt die neue pos + richtung + daempfung
  void set(PVector pos,PVector dir,float dampV)
  {
    _pos = pos.get();
    _dir.add(dir);
    _dampV = dampV;
  }
  
  // erneuert die aktuelle position
  void calcPos()
  {
    // aktuelle position verschieben
    _pos.add(_dir);
    
    // bewegungs vektor veraendert
    _dir.mult(_dampV);
    
    // teste horizontal 
    if(_pos.x + _w/2 > width)
    {
      _dir.x *= -1;
      _pos.x = width - _w/2;
    }
    else if(_pos.x - _w/2 < 0)
    {
      _dir.x *= -1;
      _pos.x = _w/2;
    }
    
    // teste vertikal 
    if(_pos.y + _h/2 > height)
    {
      _dir.y *= -1;
      _pos.y = height - _w/2;
    }
    else if(_pos.y - _h/2 < 0)
    {
      _dir.y *= -1;
      _pos.y = _h/2;
    }
    
  }
  
  // zeichnet den ball
  void draw()
  {
    calcPos();
     shape(_shape,
          _pos.x,_pos.y,
          _w,_h);
  }
}
