int gridW = 15;
int gridH = 15;
int xStep = 60;
int yStep = 60;


PShape[] imageList;   
   
void setup()
{
  size(800, 800);
  smooth();
     
  imageList = new PShape[9];
  imageList[0] = loadShape("perm1.svg");
  imageList[1] = loadShape("perm2.svg");
  imageList[2] = loadShape("perm3.svg");
  imageList[3] = loadShape("perm4.svg");
  imageList[4] = loadShape("perm5.svg");
  imageList[5] = loadShape("perm6.svg");
  imageList[6] = loadShape("perm7.svg");
  imageList[7] = loadShape("perm8.svg");
  imageList[8] = loadShape("perm9.svg");
}
   
void draw()
{
  background(255);
  int newIndex;
 for (int i=0; i < gridW; i++)
  {
    for (int j=0; j < gridH; j++)
    {
      PVector pos = new PVector(i * xStep, j * yStep);
      newIndex = calcIndex(pos, imageList.length);
      pushMatrix();
      translate(pos.x, pos.y);
    scale(.5);
      shape(imageList[newIndex], 0, 0);
      popMatrix();
    }
  }  
}
   
int calcIndex(PVector obj,int maxIndex)
{
  float distance = dist(obj.x,obj.y, mouseX,mouseY);
  return (int)map(distance,0,dist(0,0,width,height),0,maxIndex-1);
}
   
   