import de.voidplus.leapmotion.*;

LeapMotion leap;

PVector controller;
int displayCount = 0;
float reactorScaler = 0.01;
Boolean mouseMode = true;

// display object  
Visual myVisual;


void setup() {
  size(displayWidth, displayHeight);
  background(255);
  leap = new LeapMotion(this); 
  controller = new PVector(0, 0);
  //
  myVisual = new VisualA();
}


void draw() {
  background(255);

  if (mouseMode) {
    controller.x = mouseX;
    controller.y = mouseY;
  } else {
    getHandPositions();
  }

  myVisual.draw(controller, reactorScaler);
}

//
//leap motion control
//
void getHandPositions() {
  for (Hand hand : leap.getHands()) {

    // ----- Variables -----
    PVector hand_position    = hand.getPosition();
    boolean hand_is_left     = hand.isLeft();
    boolean hand_is_right    = hand.isRight();
    if (hand_is_left) {
      reactorScaler = map(hand_position.y, 650, 0, 0.001, 0.01);
    } 
    if (hand_is_right) {
      controller = hand_position;
    }
  }
}

// Incase there is no leap motion inputs, use the mouse and keyboard

void leapOnConnect() {
  mouseMode = false;
}

void leapOnDisconnect() {
  mouseMode = true;
}

void keyPressed() {
  switch(key) {
    case('1'):  
    myVisual = new VisualA();
    break;
    case('2'): 
    myVisual = new VisualB();
    break;
    case('3'): 
    // myVisual = new VisualC();
    break;
    case('4'): 
   //  myVisual = new VisualD();
    break;
  default :
    println(keyCode);
    if (keyCode == UP) {
      reactorScaler+= .0005;
    } else if (keyCode == DOWN) {
      reactorScaler-= .0005;
    }
    break;
  }
}