class VisualA extends Visual {
  int shapeWidth = 60; 
  int shapeHeight = 60;  
  int gridWidth; 
  int gridHeight; 

  VisualA() {
    gridWidth = width/shapeWidth+1; 
    gridHeight = height/shapeHeight+1;
  }

  void draw(PVector _reactorPosition, float _reactorScaler) {
    stroke(0); 
    background(255);
    _reactorScaler/=5; 
    for (int i = 0; i<gridWidth; i++ ) {
      for (int j = 0; j<gridHeight; j++ ) {
        float posX =  i*shapeWidth;
        float posY =  j*shapeHeight;
        float reactorDistance = sqrt((_reactorPosition.x-posX)*(_reactorPosition.x-posX)+(_reactorPosition.y-posY)*(_reactorPosition.y-posY)); ///or user dist(point1.x, point1.y, point2.x, point2.y);
        float scaler = reactorDistance*_reactorScaler;
        noFill();
        ellipse(posX, posY, shapeWidth*scaler, shapeHeight*scaler);
      };
    };
  }
}