class VisualB extends Visual {
  int shapeWidth = 20; 
  int shapeHeight = 20;  
  int gridWidth; 
  int gridHeight; 

  VisualB() {
    gridWidth = width/shapeWidth+1; 
    gridHeight = height/shapeHeight+1;
  }

  void draw(PVector _reactorPosition, float _reactorScaler) {
    stroke(0); 
    background(255);
    println(_reactorScaler*2);
    for (int i = 0; i<gridWidth; i++ ) {
      beginShape();
      for (int j = 0; j<gridHeight; j++ ) {  
        float scaler = dist(_reactorPosition.x, _reactorPosition.y, shapeWidth*i, shapeHeight*j)*_reactorScaler;
        vertex(shapeWidth*i+(j%2*scaler), shapeHeight*j+(i%2*scaler));
      }
      endShape();
    }; 
    for (int j = 0; j<gridHeight; j++ ) {   
      beginShape();
      for (int i = 0; i<gridWidth; i++ ) {
        float scaler = dist(_reactorPosition.x, _reactorPosition.y, shapeWidth*i, shapeHeight*j)*reactorScaler;
        vertex(shapeWidth*i+(j%2*scaler), shapeHeight*j+(i%2*scaler));
      }
      endShape();
    };
  }
}