/* --------------------------------------------------------------------------
 * BouncingBall
 * --------------------------------------------------------------------------
 * prog:  Max Rheiner 
 * date:  03/1/2011 (m/d/y)
 * ----------------------------------------------------------------------------
 */
 
class BouncingBall
{
  PVector _pos;
  PVector _dir;
  float   _dampV;
  int     _d;
  int     _r;
  
  // konstruktor
  BouncingBall(int x,int y,int radius)
  {
    _pos = new PVector(x, y);
    _dir = new PVector(0,0);
    _dampV = 1;
    
    _r = radius;
    _d = _r * 2;
  }
  
  // setzt die neue pos + richtung + daempfung
  void set(PVector pos,PVector dir,float dampV)
  {
    _pos = pos.get();
    _dir = dir.get();
    _dampV = dampV;
  }
  
  // erneuert die aktuelle position
  void calcPos()
  {
    // aktuelle position verschieben
    _pos.add(_dir);
    
    // bewegungs vektor veraendert
    _dir.mult(_dampV);
    
    // teste horizontal 
    if(_pos.x + _r > width)
    {
      _dir.x *= -1;
      _pos.x = width - _r;
    }
    else if(_pos.x - _r < 0)
    {
      _dir.x *= -1;
      _pos.x = _r;
    }
    
    // teste vertikal 
    if(_pos.y - _r < 0)
    {
      _dir.y *= -1;
      _pos.y = _r;
    }
    
  }

  // zeichnet den ball
  void draw()
  {
    calcPos();
    pushStyle();
    fill(255);
    noStroke();
    ellipse(_pos.x,_pos.y,_d,_d);
    popStyle();
  }
}
