/* --------------------------------------------------------------------------
 * BreakOut
 * --------------------------------------------------------------------------
 * prog:  Max Rheiner 
 * date:  26/09/2012 (m/d/y)
 * ----------------------------------------------------------------------------
 */

import ddf.minim.*;

Minim minim;
AudioSample ballHitSnd;
AudioSample ballHitSchlaegerSnd;

BouncingBall ball;
Racket       schlaeger = null;
Brick[]      brickList = null;

final static int GAME_MODE_MENU      = 0;
final static int GAME_MODE_PLAY      = 1;
final static int GAME_MODE_GAMEOVER  = 2;

int          gameMode = GAME_MODE_MENU;

void setup()
{
  size(800, 600); 

  ball = new BouncingBall(width/2, height/2, 7);

  schlaeger = new Racket(0, height - 40, 70, 15);   

  // sound init
  minim = new Minim(this);
  ballHitSnd = minim.loadSample("hit.mp3");
  ballHitSchlaegerSnd = minim.loadSample("hitSchlaeger.mp3");

  smooth(); 
  noCursor();
}

void initGameScene()
{
  // setzte die start posititon des balles
  ball.set(new PVector(width/2, height/2), new PVector(random(-7, 7), -7), 1);

  // erzeuge die ziegel
  brickList = new Brick[(int)random(3, 12)];
  for (int i=0;i < brickList.length;i++)
  {
    brickList[i] = new Brick(200 + i * 55, 200, 50, 20);
  }
}


void draw()
{
  // ghosting
  fill(0, 0, 0, 100);
  rect(0, 0, width, height);

  drawScene();
}

void drawScene()
{
  switch(gameMode)
  {
  case GAME_MODE_MENU:
    drawMenu();
    break;
  case GAME_MODE_PLAY:
    drawGame();
    break;  
  case GAME_MODE_GAMEOVER:
    drawGameOver();
    break;
  }
}

void drawMenu()
{
  pushStyle();
  fill(255);
  text("BreakOut", 350, 200);  

  text("\'p\' : start game", 350, 230);  
  text("Space : stop game", 350, 250);   
  popStyle();
}

void drawGameOver()
{
  pushStyle();
  fill(255);
  text("Game Over", 350, 200);  
  popStyle();
}

void drawGame()
{
  // update die daten, berechne kollisionen
  updateScene();

  // zeichne ziegel
  for (int i=0;i < brickList.length;i++)
  {
    if (brickList[i] != null)
      brickList[i].draw();
  }

  // zeichne den ball
  ball.draw();

  // zeichne schlaeger
  schlaeger.draw();
}

void keyPressed()
{
  switch(key)
  {
  case 'p':
    // start game
    gameMode = GAME_MODE_PLAY;
    initGameScene();
    break;
  case ' ':
    // end
    gameMode = GAME_MODE_MENU;
    break;
  }
}

void  updateScene()
{
  // test ob ball aus dem spielfeld ist
  if (ball._pos.y > height- ball._r)
  {
    gameMode = GAME_MODE_GAMEOVER;
    return;
  }

  // update schlaeger pos
  schlaeger.move(mouseX, mouseY);
  
  PVector hitPos = new PVector();
  float  hitV;
  float  speed;
  
  // teste ob ball den schlaeger trifft
  int retVal = schlaeger.checkCollision(ball._pos.x, ball._pos.y, ball._r, ball._dir,hitPos);
  switch(retVal)
  {
  case Brick.HIT_LEFT:
     // aendere flugrichtung ball
    ball._dir.x *= -1;
   
    // setzte ball buendig auf den schlaeger(das er nicht im schlaeger ist)
    ball._pos.x = schlaeger._pos.x - schlaeger._w/2 - ball._r;
    
    // spiele sound
    ballHitSchlaegerSnd.trigger();
    break;
  case Brick.HIT_RIGTH:
     // aendere flugrichtung ball
    ball._dir.x *= -1;
   
    // setzte ball buendig auf den schlaeger(das er nicht im schlaeger ist)
    ball._pos.x = schlaeger._pos.x + schlaeger._w/2 + ball._r;

    // spiele sound
    ballHitSchlaegerSnd.trigger();
    break;
  case Brick.HIT_TOP:
     // aendere flugrichtung ball
    
    // anschnitt berechnen 
    hitV = hitPos.x - (schlaeger._pos.x - schlaeger._w/2);
    hitV = 1.0 / schlaeger._w * hitV - 0.5;
    
    speed = ball._dir.mag();

    ball._dir.x += hitV * 8; 
    ball._dir.y *= -1;
    
    // ball soll die gleiche geschwindigkeit haben wie am anfang
    ball._dir.normalize();
    ball._dir.mult(speed);
   
    // setzte ball buendig auf den schlaeger(das er nicht im schlaeger ist)
    ball._pos.y = schlaeger._pos.y - schlaeger._h/2 - ball._r ;
    
    // spiele sound
    ballHitSchlaegerSnd.trigger();
    break; 
  case Brick.HIT_BOTTOM:
    // aendere flugrichtung ball
    
    // anschnitt berechnen 
     hitV = hitPos.x - (schlaeger._pos.x - schlaeger._w/2);
    hitV = 1.0 / schlaeger._w * hitV - 0.5;
    
    speed = ball._dir.mag();

    ball._dir.x += hitV * 8; 
    ball._dir.y *= -1;
    
    // ball soll die gleiche geschwindigkeit haben wie am anfang
    ball._dir.normalize();
    ball._dir.mult(speed);
   
    // setzte ball buendig auf den schlaeger(das er nicht im schlaeger ist)
    ball._pos.y = schlaeger._pos.y + schlaeger._h/2 + ball._r ;

    // spiele sound
    ballHitSchlaegerSnd.trigger();
    break;
  }
  
  // test ob ball einen ziegel trifft
  for (int i=0;i < brickList.length;i++)
  {
    if (brickList[i] != null)
    {
      retVal = brickList[i].checkCollision(ball._pos.x, ball._pos.y, ball._r, ball._dir,hitPos);
      switch(retVal)
      {
      case Brick.HIT_LEFT:
      case Brick.HIT_RIGTH:
        // aendere flugrichtung ball
        ball._dir.x *= -1;

        // entferne ziegel aus liste
        brickList[i] = null;
        
        // spiele sound
        ballHitSnd.trigger();
        break;
      case Brick.HIT_TOP:
      case Brick.HIT_BOTTOM:
        // aendere flugrichtung ball
        ball._dir.y *= -1;

        // entferne ziegel aus liste
        brickList[i] = null;

        // spiele sound
        ballHitSnd.trigger();
        break;
      }
    }
  }
}





