
final static int STATUS_STARTSCREEN   = 0;
final static int STATUS_PLAY          = 1;
final static int STATUS_GAMEOVER      = 2;

ArrayList<Racer> racerList = new ArrayList<Racer>();
int gameStatus = 0;
int gameWinner;
PVector endPos = null;

void setup()
{
  size(800,600);
   
  racerList.add(new Racer(color(255,0,0)));
  racerList.add(new Racer(color(0,255,0)));
}

void draw()
{
  switch(gameStatus)
  {
  case STATUS_STARTSCREEN:
    // draw startup screen
    drawStartScreen();
    break;
  case STATUS_PLAY:
    // calculate 
    updateGame();
    
    // draw game
    drawGame();
    break;
  case STATUS_GAMEOVER:
    drawGameOverScreen();
    break;
  }
}

void drawStartScreen()
{
    background(0);
 
    textSize(32);
    fill(1,255,2);
    text("LightRacer !",300,200);

    textSize(24);
    text("Press Space to start.",300,250);
}

void drawGameOverScreen()
{
    background(0);
 
    textSize(32);
    fill(1,255,2);
    text("Game Over",300,200);

    textSize(24);
    text("Player " + gameWinner + " won!!!!!!!!!",300,250);
    
    fill(1,255,2,100);
    ellipse(endPos.x,endPos.y,30,30);
}

void drawGame()
{
  background(0);
  
  for(int i=0; i < racerList.size();i++)
    racerList.get(i).draw();
}

void updateGame()
{
  // update the racer + collision
  for(int i=0; i < racerList.size();i++)
    racerList.get(i).update();

  // check for collision
  PVector colPos = new PVector();
  boolean hit = false;
  
  // check if first race collides with second racer
  if(racerList.get(0).checkCollision(racerList.get(1), colPos))
    hit = true;
  // check if second racer coolides with first racer  
  else if(racerList.get(1).checkCollision(racerList.get(0), colPos))
    hit = true;
    
  if(hit)  
  {
    // check which one is closer to the collision center
    float dist1 = PVector.sub(colPos,racerList.get(0).pos()).mag();
    float dist2 = PVector.sub(colPos,racerList.get(1).pos()).mag();
    
    if(dist1 < dist2)
      gameWinner = 2;
    else
      gameWinner = 1;
      
    gameStatus = STATUS_GAMEOVER;
    endPos = colPos;
  }
  
}

void resetGame()
{
  // set the racers to the start pos
  racerList.get(0).setStart(new PVector(150,100),1.8);  
  racerList.get(1).setStart(new PVector(650,100),1.8);
}

void keyPressed()
{
  switch(key)
  {
  case ' ':
    gameStatus = STATUS_PLAY;
    resetGame();
    break;
  case 'x':
    gameStatus = STATUS_STARTSCREEN;
    break;
  // control for first racer
  case 'a':
    racerList.get(0).left();
    break;
  case 's':
    racerList.get(0).right();
    break;
  // control for second racer
  case 'k':
    racerList.get(1).left();
    break;
  case 'l':
    racerList.get(1).right();
    break;
  }
}