class Racer
{
  Trail  trail = new Trail();
  PVector dir;
  float angle;
  float speed;
  color col;
  
  public Racer(color col)
  {
    float speed = 0;
    this.col = col;
  }
  
  void setStart(PVector pos,float speed)
  {
    this.speed = speed;
    
    angle = 90;
    
    trail.reset();
    trail.addNewPos(pos);
    trail.addNewDirection(pos);
  }
  
  void left()
  {
    angle -=90;
    angle = angle % 360;
  
    trail.addNewDirection(trail.curPos);
  }
  
  void right()
  {
    angle +=90;
    angle = angle % 360;   

    trail.addNewDirection(trail.curPos);
  }
  
  boolean checkCollision(Racer racerComp, PVector collisionPos)
  {
    return trail.checkCollision(racerComp.trail,collisionPos);
  }
  
  PVector pos()
  {
    return trail.curPos;
  }
  
  void update()
  {
    dir = new PVector(1,0);
    dir.rotate(radians(angle));
    
    PVector pos = new PVector();
    
    pos.add(PVector.mult(dir,speed));
    pos.add(trail.curPos);
    
    // check if racer leaves the screen
    if(pos.x > width)
    {
      trail.addNewPos(pos);
      trail.addNewStart(new PVector(0,pos.y));
    }
    else if(pos.x < 0)
    {
      trail.addNewPos(pos);
      trail.addNewStart(new PVector(width,pos.y));
    }
    else if(pos.y > height)
    {
      trail.addNewPos(pos);
      trail.addNewStart(new PVector(pos.x,0));
    }
    else if(pos.y < 0)
    {
      trail.addNewPos(pos);
      trail.addNewStart(new PVector(pos.x,height));
    }
    else
      trail.addNewPos(pos); 
      
    trail.age();
    
  }
  
  void draw()
  {
    stroke(col);
    fill(col);
    
    trail.draw();
   
    // draw razer
    stroke(col);
    fill(col);
    strokeWeight(1);
    
    pushMatrix();
    
    translate(trail.curPos.x,trail.curPos.y);
    
    rotate(radians(angle));
    
    beginShape();
    vertex(-3,2);
    vertex(5,0);
    vertex(-3,-2);
    endShape(CLOSE);
    
    popMatrix();
  }
  
}