class Trail
{
  ArrayList<PVector> posList = new ArrayList<PVector>();
  PVector            curPos = new PVector();
  int                lineSeg = 0;
  int                maxLines = 10;

  Trail()
  {
  }

  void addNewPos(PVector pos)
  {
    curPos = pos.copy();
  }

  void addNewDirection(PVector pos)
  {
    posList.add(curPos);
    curPos = pos.copy();

    lineSeg++;    

  }
  
  void addNewStart(PVector pos)
  {
    posList.add(curPos);
    lineSeg++;

    posList.add(null);
    posList.add(pos);
    lineSeg++;

    curPos = pos.copy();
  }

  void age()
  {
    if(posList.size() > maxLines)
      posList.remove(0);
    
  }

  void draw()
  {
    if (posList.size() < 2)
    {
      if (posList.size() > 0)
      {
        line(posList.get(0).x, posList.get(0).y, 
          curPos.x, curPos.y);
      }             
      return;
    }

    PVector p1, p2;

    p1 = posList.get(0);
    for (int i=1; i < posList.size(); i++)
    {
      p2 = posList.get(i);

      if (p1 != null && p2 != null)
        line(p1.x, p1.y, p2.x, p2.y);

      p1 = p2;
    }

    line(p1.x, p1.y, curPos.x, curPos.y);
  }

  void reset()
  {
    posList.clear();
    lineSeg = 0;
  }

  boolean checkCollision(Trail trailComp, PVector collisionPos)
  {
    if (lineSeg <= 0 || trailComp.lineSeg <= 0)
      return false;

    // get last segments
    PVector res;

    PVector p1 = posList.get(posList.size()-1);
    PVector p2 = curPos;

    PVector pComp1 = trailComp.posList.get(0);
    PVector pComp2;

    for (int i=1; i < trailComp.posList.size(); i++)
    {
      pComp2 =  trailComp.posList.get(i);

      if (pComp1 != null && pComp2 != null)
      {
        res = segIntersection(p1.x, p1.y, p2.x, p2.y, 
          pComp1.x, pComp1.y, pComp2.x, pComp2.y); 

        if (res != null)
        {
          collisionPos.set(res.x, res.y); 
          return true;
        }
      }        
      pComp1 = pComp2;
    }

    // check if a collision is in the current line segment
    pComp1 = trailComp.posList.get(trailComp.posList.size()-1);
    pComp2 = trailComp.curPos;

    res = segIntersection(p1.x, p1.y, p2.x, p2.y, 
                          pComp1.x, pComp1.y, pComp2.x, pComp2.y); 

    if (res != null)
    {
      collisionPos.set(res.x, res.y); 
      return true;
    }   

    return false;
  }
}


// checkout http://wiki.processing.org/w/Line-Line_intersection
PVector segIntersection(float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4) 
{ 
  float bx = x2 - x1; 
  float by = y2 - y1; 
  float dx = x4 - x3; 
  float dy = y4 - y3;
  float b_dot_d_perp = bx * dy - by * dx;
  if (b_dot_d_perp == 0) {
    return null;
  }
  float cx = x3 - x1;
  float cy = y3 - y1;
  float t = (cx * dy - cy * dx) / b_dot_d_perp;
  if (t < 0 || t > 1) {
    return null;
  }
  float u = (cx * by - cy * bx) / b_dot_d_perp;
  if (u < 0 || u > 1) { 
    return null;
  }
  return new PVector(x1+t*bx, y1+t*by);
}  