
class ForcePoint
{
  int posX;
  int posY;
  float radius;
  PVector dir;
  float damperValue;
  float maxDist = 30;
  
  ForcePoint(int x,int y,float radius,float damperValue)
  {
    posX = x;
    posY = y;
    
    dir = new PVector(0,0);
    this.radius = radius;
    this.damperValue = damperValue;
  }

  void setInput(int mouseX,int mouseY,int extraFlag)
  {
    PVector mouseDist = new PVector(mouseX - posX,mouseY - posY);
    if(mouseDist.mag() < radius)
    {
      mouseDist.normalize();
      dir.add(PVector.mult(mouseDist,2));
      
      // check for max length
      if(dir.mag() > maxDist)
      {
        dir.normalize();
        dir = PVector.mult(dir,maxDist);
      }        
    }
  }    
 
  void update()
  {  
    dir.mult(damperValue);
  }
  
  void draw()
  {
    stroke(255);
    
    point(posX,posY);         
    line(posX,posY,
         dir.x + posX,dir.y + posY);
  }
}
