
class ForcePointTrail extends ForcePoint
{
  ArrayList<PVector>  _trail;
  int                 _trailMaxSize = 15;
  float               _dirMult = 2;
  float               _backDirMult = 0.01;
  
  ForcePointTrail(int x,int y,float radius,float damperValue)
  {
    super(x,y,radius,damperValue);
    
    _trail = new ArrayList<PVector>();
    _trail.add(new PVector(x,y));
  }
  
  void setInput(int mouseX,int mouseY,int extraFlag)
  {
    PVector endPos = lastPoint();
    PVector mouseDist = new PVector(mouseX - endPos.x,mouseY - endPos.y);
    
    if(mouseDist.mag() <= radius)
    {
      float strength = mouseDist.mag() / radius;
      float scaleVal = (1.0 - strength) * _dirMult;
      
      if(extraFlag == 1)
        scaleVal *= -1;
      
      mouseDist.normalize();
      dir.add(PVector.mult(mouseDist,scaleVal));          
    }
  }      
  
  PVector lastPoint()
  {
    return _trail.get(_trail.size() - 1);
  }
  
  void update()
  {
    PVector endPos = lastPoint();
    PVector dirBack = PVector.sub(new PVector(posX,posY),endPos);
    
    dirBack.mult(_backDirMult);
    dir.add(dirBack);
    dir.mult(damperValue);

    PVector newEndPos = PVector.add(dir,endPos);
    _trail.add(newEndPos);
    
    // check if list reached the max. length
    if(_trail.size() > _trailMaxSize)
      _trail.remove(0);
  }
  
  void draw()
  {
    PVector pos;
        
    stroke(255);
    noFill();
    
    beginShape();
    for(int i=0;i < _trail.size();i++)
    {
      pos = _trail.get(i);
      vertex(pos.x,pos.y);
    }
    endShape();
  }
  
}
