import controlP5.*;

ControlP5 cp5;

Map gameMap;
Car gameCar;
Network neuralnet;
int gameH;
int gameW;
int networkH;
int networkW;


//PFont font;


void setup() {
  size(1300,600);
  gameH = height;
  gameW = floor(width*.4);
  networkH = height;
  networkW = width-gameW;
  setupSigmoid();
  gameMap = new Map(floor(gameW*.8),floor(gameH*.8));
  neuralnet = new Network(2,3,2);
  PVector position = new PVector(width/2, height/2);
  PVector direction = new PVector(1,1);
  gameCar = new Car(position, direction, 10, 3, 1);
  background(100);
  gameMap.draw();
  loadPixels();
  // create a new button with name 'buttonA'
  // The vlw file should be saved in the sketch folder
  //font = loadFont("font.vlw");
  //textFont(font, 10);
  textSize(10);
  cp5 = new ControlP5(this);

  cp5.addButton("zeroAll")
  .setValue(0)
  .setPosition(gameW+20,20)
  .setSize(50,20)
  .setCaptionLabel("zero all")
  ;

  cp5.addButton("randomAll")
  .setValue(100)
  .setPosition(gameW+20,50)
  .setSize(50,20)
  .setCaptionLabel("randomise")
  ;

  cp5.addSlider("speed")
    .setPosition(20,20)
    .setRange(0.2,5.0)
    .setSize(50,20)
    .setValue(3.0);
    ;
}

public void zeroAll(int theValue) {
  neuralnet.zeroAll();
}

public void randomAll(int theValue) {
    neuralnet.randomAll();
}

public void speed(float theValue) {
    //println(theValue);
    gameCar.speed = theValue;
}


void draw() {

  background(0);
  fill(100);
  rect(0,0,gameW,gameH);
  gameMap.draw();
  gameCar.draw();
  float[] vision = { gameCar.eyeA, gameCar.eyeB};
  neuralnet.respond(vision);
  neuralnet.display();
}
