class Ship extends Satellite {
  Ship(PVector position, PVector direction, float diameter, float speed, float damper)
  {
    super(position, direction, diameter, speed, damper);
  }

  void display()
  {
    super.display();
    pushStyle();
    pushMatrix();
    fill(255, 255, 255);
    translate(position.x, position.y);
    rotate(rotation.heading());
    fill(100, 255, 100);
    triangle(diameter/2, 0, -diameter/2, diameter/2, -diameter/2, -diameter/2);
    popMatrix();
    popStyle();
  }

  void updateSpeed()
  {
    PVector rotationStep = rotation.copy();
    rotationStep.mult(speed);
    velocity.add(rotationStep);
    drawTail();
  }

  void updateAngle(float theta) { 
    rotation.rotate(theta);
  }

  void collision() {
    println("hit");
  };

  void drawTail() {  
    int alternator = int(position.x + position.y);
    alternator = alternator%2;
    if (alternator == 0) {
      pushStyle();
      pushMatrix();
      translate(position.x, position.y);
      rotate(rotation.heading());
      println(alternator);
      fill(200, 200, 0);
      translate(-diameter/2, 0);
      triangle(-20, 0, 0, 5, 0, -5);
      popMatrix();
      popStyle();
    }
  };
}