// do not edit this file
import oscP5.*;
import netP5.*;
OscP5 oscP5;
NetAddress myRemoteLocation;
//
boolean displayWindow = false;
PVector[] locArray = new PVector[15]; // a longer array means more references for calculating average
int readIndex = 0;
PVector total = new PVector();
PVector average  = new PVector();
PVector face = new PVector();
PVector orientation = new PVector();
int updateFlag = 0;

void setupTracking() {
  oscP5 = new OscP5(this, 8338);

  for (int i = 0; i<locArray.length; i++) {
     locArray[i] = new PVector();
   }
  myRemoteLocation = new NetAddress("localhost", 12000);

  oscP5.plug(this, "pose", "/pose/position");
  oscP5.plug(this, "scale", "/pose/scale");
  oscP5.plug(this, "orientation", "/pose/orientation");
}

public void pose(float X, float Y) {
  float Width = 640; //width from face osc
  float Height = 480; //height from face osc
  X = (X/Width);
  Y = (Y/Height);
  face.x = X;
  face.y = Y;
  updateFlag = 0;
}

public void scale(float A) {
  face.z = map(A, 0, 10, 0, 1);
}

public void orientation(float X,float Y,float Z) {
  orientation.x = X;
  orientation.y = Y;
  orientation.z = Z;
}

PVector faceLocation() {
  // smooth readings out to avoid any shake
   total = total.sub(locArray[readIndex]);
   if (updateFlag <=5) {
     locArray[readIndex] = face.copy();
   } else {
     locArray[readIndex] = new PVector(.5,.5,0);
   }
   total = total.add(locArray[readIndex]);
   readIndex = readIndex + 1;
   if (readIndex >= locArray.length) {
     readIndex = 0;
   }
   // calculate average
   average.x = total.x /  locArray.length;
   average.y = total.y /  locArray.length;
   average.z = total.z /  locArray.length;
    updateFlag ++;
   return average.copy();
}
PVector orient() {
  return orientation.copy();
}


/* incoming osc message are forwarded to the oscEvent method. */
void oscEvent(OscMessage theOscMessage) {
  /* with theOscMessage.isPlugged() you check if the osc message has already been
   * forwarded to a plugged method. if theOscMessage.isPlugged()==true, it has already
   * been forwared to another method in your sketch. theOscMessage.isPlugged() can
   * be used for double posting but is not required.
   */
  if (theOscMessage.isPlugged()==false) {
    /* print the address pattern and the typetag of the received OscMessage */
    // println("### received an osc message.");
    //println("### addrpattern\t"+theOscMessage.addrPattern()+ " typetag\t"+theOscMessage.typetag());
  }
}
