class myShape {

  PVector pos;
  PVector targetPos;
  PVector mousePos;
  float speed;

  myShape(float _speed) {
    speed = _speed;
    pos = new PVector(0, 0);
    targetPos = new PVector(0, 0);
    mousePos = new PVector(width/2, height/2);
  }

  void update() {
    mousePos.set(mouseX, mouseY);
    targetPos.set(mousePos); 
    targetPos.sub(pos);  // find the vector between mouse position and ellipse position
    targetPos.mult(speed); // each step in the animation will move this percentage of the distance to the target position
    pos.add(targetPos);
    //ellipse(pos.x, pos.y, 60, 60);
    pushMatrix();
    translate(pos.x, pos.y);
    rotate(calcAngle(pos, mousePos));
    triangle(0,0,-5,20,5,20);
    popMatrix();
  }

  float calcAngle(PVector p1, PVector p2)
  {
    return -atan2(p1.x - p2.x,p1.y - p2.y);
  }
}
