/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.IOException;
import processing.core.PApplet;
import processing.core.PFont;

public class viewer
extends PApplet {
    String m_viewer_version = "Viewer 1.6";
    Line[] plines = new Line[1];
    Arc[] arcs = new Arc[1];
    int[] color_table = new int[]{-869033473, -862375168, -855703552, -855664384, -855638272, -869007616, -872414977, -865730407, -858993460, -855638017};
    int bg_color = -16777216;
    float x_scale = -200.0f;
    float y_scale = -200.0f;
    float x_offset = 0.0f;
    float y_offset = 300.0f;
    float minx = 0.0f;
    float miny = 0.0f;
    float maxx = 0.0f;
    float maxy = 0.0f;
    PFont metaBold;
    String filename = "optimize_me.txt";
    String comment = "";
    float tool_size = 0.001f;
    boolean tool_size_set = false;
    float tool_depth = 0.0f;
    boolean tool_depth_set = false;
    boolean have_spots = false;
    int m_pass;
    int total_passes;
    boolean m_monochrome = false;
    int m_window_width = 800;
    int m_window_height = 600;
    int m_window_x = 0;
    int m_window_y = 0;
    float m_scale = 1.0f;
    float m_trans_x = 0.0f;
    float m_trans_y = 0.0f;
    int draw_cnt = 0;
    boolean m_drawing;
    boolean m_need_resize = true;

    public void prepare_objects(String[] stringArray, Arc[] arcArray) {
        Object object;
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n] != null && ((String[])(object = viewer.split(stringArray[n], ','))).length == 5) {
                float f = PApplet.parseFloat(object[0]);
                float f2 = PApplet.parseFloat(object[1]);
                float f3 = PApplet.parseFloat(object[2]);
                float f4 = PApplet.parseFloat(object[3]);
                int n2 = PApplet.parseInt(object[4]);
                this.plines[n] = new Line(f, f2, f3, f4, n2);
                this.minx = viewer.min(this.minx, f);
                this.miny = viewer.min(this.miny, f2);
                this.maxx = viewer.max(this.maxx, f);
                this.maxy = viewer.max(this.maxy, f2);
                this.minx = viewer.min(this.minx, f3);
                this.miny = viewer.min(this.miny, f4);
                this.maxx = viewer.max(this.maxx, f3);
                this.maxy = viewer.max(this.maxy, f4);
            }
            ++n;
        }
        n = 0;
        while (n < arcArray.length) {
            object = arcArray[n];
            if (object != null) {
                this.minx = viewer.min(this.minx, object.xc - object.radius);
                this.miny = viewer.min(this.miny, object.yc - object.radius);
                this.maxx = viewer.max(this.maxx, object.xc + object.radius);
                this.maxy = viewer.max(this.maxy, object.yc + object.radius);
            }
            ++n;
        }
    }

    public void set_scaling() {
        this.x_scale = (float)(this.width - 100) / (this.maxx - this.minx);
        this.y_scale = (float)(this.height - 100) / (this.maxy - this.miny);
        this.y_scale = this.x_scale = viewer.min(this.x_scale, this.y_scale);
        this.y_scale = -viewer.abs(this.y_scale);
        if (this.minx < 0.0f) {
            this.x_offset += viewer.abs(this.minx) * this.x_scale;
        }
        this.x_offset += 20.0f;
        this.y_offset = this.height - 40;
    }

    public void rtext(String string, float f, float f2) {
        this.text(string, f - this.textWidth(string), f2);
    }

    public void resize_window() {
        this.m_window_x = (this.screen.width - this.m_window_width) / 2;
        this.screen.height = this.m_window_height;
        this.m_window_y = this.screen.height / 4;
        this.size(this.m_window_width, this.m_window_height);
        this.frame.setLocation(this.m_window_x, this.m_window_y);
    }

    public void setup() {
        String string = null;
        String[] stringArray = new String[1];
        BufferedReader bufferedReader = this.createReader(this.filename);
        do {
            try {
                string = bufferedReader.readLine();
            }
            catch (IOException iOException) {
                viewer.println("IO exception caught");
            }
            if (string == null) continue;
            String[] stringArray2 = viewer.match(string, "^# board=(.+)");
            if (stringArray2 != null) {
                this.comment = stringArray2[1];
            }
            if ((stringArray2 = viewer.match(string, "^# tool size=(.+)")) != null) {
                this.tool_size = PApplet.parseFloat(stringArray2[1]);
                this.tool_size_set = true;
            }
            if ((stringArray2 = viewer.match(string, "^# depth=(.+)")) != null) {
                this.tool_depth = PApplet.parseFloat(stringArray2[1]);
                this.tool_depth_set = true;
            }
            if ((stringArray2 = viewer.match(string, "^# pass=(.+)")) != null) {
                this.m_pass = PApplet.parseInt(stringArray2[1]);
                this.total_passes = viewer.max(this.total_passes, this.m_pass);
            }
            if ((stringArray2 = viewer.match(string, "^# spot drills")) != null) {
                this.m_pass = 0;
                this.have_spots = true;
            }
            if ((stringArray2 = viewer.match(string, "^# arc xc=([-+]*[0-9]*\\.[0-9]+) yc=([-+]*[0-9]*\\.[0-9]+) sang=([-+]*[0-9]*\\.[0-9]+) eang=([-+]*[0-9]*\\.[0-9]+) radius=([-+]*[0-9]*\\.[0-9]+)")) != null) {
                Arc arc = new Arc(PApplet.parseFloat(stringArray2[1]), PApplet.parseFloat(stringArray2[2]), PApplet.parseFloat(stringArray2[3]), PApplet.parseFloat(stringArray2[4]), PApplet.parseFloat(stringArray2[5]), PApplet.parseInt(this.m_pass));
                if (arc.radius < 0.0f) {
                    arc.radius = viewer.abs(arc.radius);
                    arc.sang += 180.0f;
                    arc.eang += 180.0f;
                } else {
                    arc.sang = 360.0f - arc.sang;
                    arc.eang = 360.0f - arc.eang;
                    if (arc.sang > arc.eang) {
                        float f = arc.sang;
                        arc.sang = arc.eang;
                        arc.eang = f;
                    }
                }
                this.arcs = (Arc[])viewer.append(this.arcs, arc);
            }
            if ((stringArray2 = viewer.match(string, "^# preview window width=([0-9]+) height=([0-9]+)")) != null) {
                this.m_window_width = PApplet.parseInt(stringArray2[1]);
                this.m_window_height = PApplet.parseInt(stringArray2[2]);
                this.size(this.m_window_width, this.m_window_height);
            }
            if ((stringArray2 = viewer.match(string, "^# debug")) != null) {
                viewer.println(string);
            }
            if ((stringArray2 = viewer.match(string, "^#")) != null) continue;
            stringArray = viewer.append(stringArray, String.valueOf(string) + "," + viewer.nf(this.m_pass, 2));
        } while (string != null);
        this.plines = (Line[])viewer.expand(this.plines, stringArray.length);
        this.prepare_objects(stringArray, this.arcs);
        this.set_scaling();
        this.noLoop();
    }

    public void draw_line(Line line) {
        if (line != null) {
            if (!this.m_monochrome) {
                this.stroke(this.color_table[line.pass % 9]);
            }
            this.line(line.sx * this.x_scale + this.x_offset, line.sy * this.y_scale + this.y_offset, line.ex * this.x_scale + this.x_offset, line.ey * this.y_scale + this.y_offset);
        } else {
            viewer.println("null line");
        }
    }

    public void draw_arc(Arc arc) {
        if (arc != null) {
            if (!this.m_monochrome) {
                this.stroke(this.color_table[arc.pass % 9]);
            }
            this.noFill();
            this.arc(arc.xc * this.x_scale + this.x_offset, arc.yc * this.y_scale + this.y_offset, arc.radius * this.x_scale * 2.0f, arc.radius * -this.y_scale * 2.0f, viewer.radians(arc.sang), viewer.radians(arc.eang));
        } else {
            viewer.println("null arc");
        }
    }

    public float xso(float f) {
        return f * this.x_scale + this.x_offset;
    }

    public float yso(float f) {
        return f * this.y_scale + this.y_offset;
    }

    public void ornaments() {
        this.stroke(255.0f, 0.0f, 0.0f);
        this.fill(255.0f, 0.0f, 0.0f);
        this.strokeWeight(1.0f);
        this.line(this.xso(this.minx), this.yso(this.miny) - 10.0f, this.xso(this.minx), this.yso(this.miny));
        this.line(this.xso(this.minx), this.yso(this.miny), this.xso(this.minx) + 10.0f, this.yso(this.miny));
        this.text(String.valueOf(viewer.nfs(this.minx, 1, 3)) + ", " + viewer.nfs(this.miny, 1, 3), this.xso(this.minx) + 5.0f, this.yso(this.miny) + 12.0f);
        this.line(this.xso(this.maxx), this.yso(this.miny) - 10.0f, this.xso(this.maxx), this.yso(this.miny));
        this.line(this.xso(this.maxx), this.yso(this.miny), this.xso(this.maxx) - 10.0f, this.yso(this.miny));
        this.line(this.xso(this.maxx) - 10.0f, this.yso(this.maxy), this.xso(this.maxx), this.yso(this.maxy));
        this.line(this.xso(this.maxx), this.yso(this.maxy), this.xso(this.maxx), this.yso(this.maxy) + 10.0f);
        this.rtext(String.valueOf(viewer.nfs(this.maxx, 1, 3)) + ", " + viewer.nfs(this.maxy, 1, 3), this.xso(this.maxx), this.yso(this.maxy) - 5.0f);
        this.line(this.xso(this.minx) + 10.0f, this.yso(this.maxy), this.xso(this.minx), this.yso(this.maxy));
        this.line(this.xso(this.minx), this.yso(this.maxy), this.xso(this.minx), this.yso(this.maxy) + 10.0f);
        this.line(this.xso(0.0f) - 10.0f, this.yso(0.0f), this.xso(0.0f) + 10.0f, this.yso(0.0f));
        this.line(this.xso(0.0f), this.yso(0.0f) - 10.0f, this.xso(0.0f), this.yso(0.0f) + 10.0f);
        this.noFill();
        this.ellipse(this.xso(0.0f), this.yso(0.0f), 10.0f, 10.0f);
        this.stroke(255);
        this.text(this.comment, 10.0f, 20.0f);
        if (this.tool_size_set) {
            this.rtext("tool size " + viewer.nfs(this.tool_size, 1, 3), this.width - 120, 20.0f);
        }
        if (this.tool_depth_set) {
            this.rtext("depth " + viewer.nfs(this.tool_depth, 1, 3), this.width - 120, 20.0f);
        }
        this.rtext(String.valueOf(viewer.nfs(this.total_passes, 1)) + " passes", this.width - 40, 40.0f);
        this.text("Keys: +/- zoom, 1 no zoom, 2 zoom 2x, arrows move, a left, de right, w, up, so down", 10.0f, 40.0f);
        this.text("c toggle color, qx quit", 60.0f, 60.0f);
    }

    public void draw() {
        int n;
        this.m_drawing = true;
        this.background(this.bg_color);
        this.stroke(127);
        this.fill(this.bg_color);
        this.strokeWeight(4.0f);
        if (this.m_need_resize) {
            this.resize_window();
            this.m_need_resize = false;
        }
        this.quad(0.0f, 0.0f, this.width - 1, 0.0f, this.width - 1, this.height - 1, 0.0f, this.height - 1);
        this.strokeWeight(1.0f);
        this.fill(255.0f, 0.0f, 0.0f);
        this.metaBold = this.loadFont("BankGothic-Light-14.vlw");
        this.textFont(this.metaBold);
        this.rtext(this.m_viewer_version, this.width - 20, 20.0f);
        this.stroke(200);
        this.scale(this.m_scale);
        this.translate(this.m_trans_x, this.m_trans_y);
        if (this.plines != null) {
            this.strokeWeight(this.tool_size * this.x_scale);
            n = 0;
            while (n < this.plines.length) {
                this.draw_line(this.plines[n]);
                ++n;
            }
        } else {
            this.text("Didn't open the file", 100.0f, (float)(this.height / 2));
        }
        if (this.arcs != null) {
            this.strokeWeight(this.tool_size * this.x_scale);
            n = 0;
            while (n < this.arcs.length) {
                this.draw_arc(this.arcs[n]);
                ++n;
            }
        }
        this.ornaments();
        this.m_drawing = false;
    }

    public void keyPressed() {
        if (this.m_drawing) {
            return;
        }
        block0 : switch (this.key) {
            case 'C': 
            case 'c': {
                this.m_monochrome = !this.m_monochrome;
                break;
            }
            case '+': 
            case '=': {
                if (!(this.m_scale < 10.0f)) break;
                this.m_scale += 0.2f;
                this.m_trans_x -= (float)this.width / this.m_scale / 20.0f;
                this.m_trans_y -= (float)this.height / this.m_scale / 20.0f;
                break;
            }
            case '-': 
            case '_': {
                if (!(this.m_scale > 0.5f)) break;
                this.m_scale -= 0.2f;
                this.m_trans_x += (float)this.width / this.m_scale / 20.0f;
                this.m_trans_y += (float)this.height / this.m_scale / 20.0f;
                break;
            }
            case '1': {
                this.m_scale = 1.0f;
                this.m_trans_x = 0.0f;
                this.m_trans_y = 0.0f;
                break;
            }
            case '2': {
                this.m_scale = 2.0f;
                this.m_trans_x = -this.width / 4;
                this.m_trans_y = -this.height / 4;
                break;
            }
            case 'Q': 
            case 'X': 
            case 'q': 
            case 'x': {
                this.exit();
                break;
            }
            case 'a': {
                this.m_trans_x += (float)(this.width / 80);
                break;
            }
            case 'd': 
            case 'e': {
                this.m_trans_x -= (float)(this.width / 80);
                break;
            }
            case ',': 
            case 'w': {
                this.m_trans_y += (float)(this.width / 80);
                break;
            }
            case 'o': 
            case 's': {
                this.m_trans_y -= (float)(this.width / 80);
                break;
            }
            case '\uffff': {
                switch (this.keyCode) {
                    case 37: {
                        this.m_trans_x += (float)(this.width / 20);
                        break block0;
                    }
                    case 39: {
                        this.m_trans_x -= (float)(this.width / 20);
                        break block0;
                    }
                    case 38: {
                        this.m_trans_y += (float)(this.height / 20);
                        break block0;
                    }
                    case 40: {
                        this.m_trans_y -= (float)(this.height / 20);
                    }
                }
            }
        }
        this.background(this.bg_color);
        this.redraw();
    }

    public static void main(String[] stringArray) {
        PApplet.main(new String[]{"--bgcolor=#ffffff", "viewer"});
    }

    class Arc {
        float xc;
        float yc;
        float sang;
        float eang;
        float radius;
        int pass;

        Arc(float f, float f2, float f3, float f4, float f5, int n) {
            this.xc = f;
            this.yc = f2;
            this.sang = f3;
            this.eang = f4;
            this.radius = f5;
            this.pass = n;
        }
    }

    class Line {
        float sx;
        float sy;
        float ex;
        float ey;
        int pass;

        Line(float f, float f2, float f3, float f4, int n) {
            this.sx = f;
            this.sy = f2;
            this.ex = f3;
            this.ey = f4;
            this.pass = n;
        }
    }
}

