/*
 * Decompiled with CFR 0.152.
 */
import controlP5.Button;
import controlP5.ControlP5;
import controlP5.Slider;
import java.util.ArrayList;
import processing.core.PApplet;
import processing.core.PVector;

public class Sketch1
extends PApplet {
    ControlP5 cp5;
    Map gameMap;
    Car gameCar;
    Network neuralnet;
    int gameH;
    int gameW;
    int networkH;
    int networkW;
    ArrayList connec = new ArrayList();
    ArrayList conStr = new ArrayList();
    float LEARNING_RATE = 0.01f;
    float[] g_sigmoid = new float[200];

    public void setup() {
        this.gameH = this.height;
        this.gameW = Sketch1.floor((float)((float)this.width * 0.4f));
        this.networkH = this.height;
        this.networkW = this.width - this.gameW;
        this.setupSigmoid();
        this.gameMap = new Map(Sketch1.floor((float)((float)this.gameW * 0.8f)), Sketch1.floor((float)((float)this.gameH * 0.8f)));
        this.neuralnet = new Network(2, 3, 2);
        PVector position = new PVector((float)(this.width / 2), (float)(this.height / 2));
        PVector direction = new PVector(1.0f, 1.0f);
        this.gameCar = new Car(position, direction, 10.0f, 3.0f, 1.0f);
        this.background(100);
        this.gameMap.draw();
        this.loadPixels();
        this.textSize(10.0f);
        this.cp5 = new ControlP5((PApplet)this);
        ((Button)((Button)this.cp5.addButton("zeroAll").setValue(0.0f).setPosition((float)(this.gameW + 20), 20.0f)).setSize(50, 20)).setCaptionLabel("zero all");
        ((Button)((Button)this.cp5.addButton("randomAll").setValue(100.0f).setPosition((float)(this.gameW + 20), 50.0f)).setSize(50, 20)).setCaptionLabel("randomise");
        ((Slider)this.cp5.addSlider("speed").setPosition(20.0f, 20.0f)).setRange(0.2f, 5.0f).setSize(50, 20).setValue(3.0f);
    }

    public void zeroAll(int theValue) {
        this.neuralnet.zeroAll();
    }

    public void randomAll(int theValue) {
        this.neuralnet.randomAll();
    }

    public void speed(float theValue) {
        this.gameCar.speed = theValue;
    }

    public void draw() {
        this.background(0);
        this.fill(100);
        this.rect(0.0f, 0.0f, this.gameW, this.gameH);
        this.gameMap.draw();
        this.gameCar.draw();
        float[] vision = new float[]{this.gameCar.eyeA, this.gameCar.eyeB};
        this.neuralnet.respond(vision);
        this.neuralnet.display();
    }

    public void setupSigmoid() {
        int i = 0;
        while (i < 200) {
            float x = (float)i / 20.0f - 5.0f;
            this.g_sigmoid[i] = 2.0f / (1.0f + Sketch1.exp((float)(-2.0f * x))) - 1.0f;
            ++i;
        }
    }

    public float lookupSigmoid(float x) {
        return this.g_sigmoid[Sketch1.constrain((int)Sketch1.floor((float)((x + 5.0f) * 20.0f)), (int)0, (int)199)];
    }

    public void settings() {
        this.size(1300, 600);
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"--present", "--window-color=#000000", "--hide-stop", "Sketch1"};
        if (passedArgs != null) {
            PApplet.main((String[])Sketch1.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }

    class Car {
        PVector position = new PVector();
        PVector velocity = new PVector();
        PVector rotation = new PVector();
        float damper;
        float diameter;
        float speed;
        float radius;
        float eyeA;
        float eyeB;
        boolean draging;

        Car(PVector position, PVector direction, float diameter, float speed, float damper) {
            this.position = position;
            this.velocity = direction.normalize();
            this.damper = damper;
            this.rotation = this.velocity.copy();
            this.speed = speed;
            this.velocity.mult(speed);
            this.diameter = diameter;
            this.radius = diameter / 2.0f;
        }

        public void draw() {
            if (!this.dragNdrop()) {
                this.velocity.mult(this.damper);
                this.velocity.normalize();
                this.velocity.mult(this.speed);
                this.position.add(this.velocity);
                this.position = this.screenWrap(this.position);
            }
            Sketch1.this.pushStyle();
            Sketch1.this.pushMatrix();
            Sketch1.this.translate(this.position.x, this.position.y);
            Sketch1.this.rotate(this.rotation.heading());
            Sketch1.this.noStroke();
            Sketch1.this.triangle(this.diameter + 3.0f, 0.0f, -this.diameter, this.diameter, -this.diameter, -this.diameter);
            Sketch1.this.popMatrix();
            Sketch1.this.popStyle();
            PVector eye1 = new PVector(20.0f, 10.0f);
            eye1.rotate(this.rotation.heading());
            eye1.add(this.position.copy());
            PVector eye2 = new PVector(20.0f, -10.0f);
            eye2.rotate(this.rotation.heading());
            eye2.add(this.position.copy());
            Sketch1.this.noStroke();
            Sketch1.this.ellipse(eye1.x, eye1.y, 5.0f, 5.0f);
            this.eyeA = this.vision(eye2);
            Sketch1.this.ellipse(eye2.x, eye2.y, 5.0f, 5.0f);
            this.eyeB = this.vision(eye1);
        }

        public void updateAngle(float theta) {
            if (!this.draging) {
                this.rotation.rotate(theta);
                this.velocity.rotate(theta);
            }
        }

        public float x() {
            return this.position.x;
        }

        public float y() {
            return this.position.y;
        }

        public float vision(PVector pos) {
            int pixel = Sketch1.floor((float)pos.x) + Sketch1.floor((float)pos.y) * Sketch1.this.width;
            if (pixel < Sketch1.this.width * Sketch1.this.height && pixel > 0 && Sketch1.this.pixels[pixel] == Sketch1.this.color(255)) {
                return 1.0f;
            }
            return -1.0f;
        }

        public void steerRight() {
            this.updateAngle(0.1f);
        }

        public void steerLeft() {
            this.updateAngle(-0.1f);
        }

        public void steer(float angle) {
            this.updateAngle(angle);
        }

        public boolean dragNdrop() {
            if (Sketch1.dist((float)Sketch1.this.mouseX, (float)Sketch1.this.mouseY, (float)this.position.x, (float)this.position.y) <= this.diameter * 4.0f) {
                Sketch1.this.fill(0.0f, 116.0f, 217.0f);
                if (Sketch1.this.mousePressed) {
                    this.position.x = Sketch1.this.mouseX;
                    this.position.y = Sketch1.this.mouseY;
                    this.draging = true;
                    return true;
                }
            } else {
                Sketch1.this.fill(0);
            }
            this.draging = false;
            return false;
        }

        public PVector screenWrap(PVector pos) {
            if (pos.x > (float)Sketch1.this.gameW + this.radius) {
                pos.x = 0.0f - this.radius;
            }
            if (pos.x < 0.0f - this.radius) {
                pos.x = (float)Sketch1.this.gameW + this.radius;
            }
            if (pos.y > (float)Sketch1.this.gameH + this.radius) {
                pos.y = 0.0f - this.radius;
            }
            if (pos.y < 0.0f - this.radius) {
                pos.y = (float)Sketch1.this.gameH + this.radius;
            }
            return pos;
        }
    }

    public class Map {
        private ArrayList<PVector> MapPoints = new ArrayList();
        int noPoints = 10;

        Map(int w, int h) {
            int i = 0;
            while (i < this.noPoints) {
                float angle = (float)Math.PI * 2 / (float)this.noPoints;
                PVector point = new PVector(Sketch1.sin((float)(angle *= (float)i)), Sketch1.cos((float)angle));
                point.mult((float)w * 0.4f + Sketch1.this.random(-40.0f, 40.0f));
                point.add((float)(Sketch1.this.gameW / 2), (float)(Sketch1.this.gameH / 2));
                this.MapPoints.add(point);
                ++i;
            }
        }

        public void draw() {
            Sketch1.this.noFill();
            Sketch1.this.strokeWeight(50.0f);
            Sketch1.this.stroke(255);
            Sketch1.this.beginShape();
            PVector point = this.MapPoints.get(0);
            Sketch1.this.curveVertex(point.x, point.y);
            int i = 0;
            while (i < this.MapPoints.size()) {
                point = this.MapPoints.get(i);
                Sketch1.this.curveVertex(point.x, point.y);
                ++i;
            }
            point = this.MapPoints.get(0);
            Sketch1.this.curveVertex(point.x, point.y);
            point = this.MapPoints.get(1);
            Sketch1.this.curveVertex(point.x, point.y);
            Sketch1.this.endShape(2);
        }
    }

    class Network {
        Neuron[] input_layer;
        Neuron[] hidden_layer;
        Neuron[] output_layer;
        int w;
        int h;
        float wheelX = 0.0f;
        float wheelY = 0.0f;
        int bestIndex = 0;
        float steeringAverage = 0.0f;

        Network(int inputs, int hidden, int outputs) {
            PVector pos;
            this.input_layer = new Neuron[inputs];
            this.hidden_layer = new Neuron[hidden];
            this.output_layer = new Neuron[outputs];
            int i = 0;
            while (i < this.input_layer.length) {
                pos = new PVector((float)Sketch1.this.networkW * 0.15f, (float)(i * (Sketch1.this.networkH / 2)));
                this.input_layer[i] = new Neuron(pos);
                ++i;
            }
            int j = 0;
            while (j < this.hidden_layer.length) {
                pos = new PVector((float)Sketch1.this.networkW * 0.5f, (float)(j * (Sketch1.this.networkH / 4)));
                this.hidden_layer[j] = new Neuron(this.input_layer, pos);
                ++j;
            }
            int k = 0;
            while (k < this.output_layer.length) {
                pos = new PVector((float)Sketch1.this.networkW * 0.85f, (float)(k * (Sketch1.this.networkH / 2)));
                this.output_layer[k] = new Neuron(this.hidden_layer, pos);
                ++k;
            }
            this.wheelX = (float)Sketch1.this.networkW * 0.85f;
            this.wheelY = Sketch1.this.networkH / 2;
        }

        public void respond(float[] inputs) {
            int i = 0;
            while (i < this.input_layer.length) {
                this.input_layer[i].output = inputs[i];
                ++i;
            }
            int j = 0;
            while (j < this.hidden_layer.length) {
                this.hidden_layer[j].respond();
                ++j;
            }
            int k = 0;
            while (k < this.output_layer.length) {
                this.output_layer[k].respond();
                ++k;
            }
        }

        public void zeroAll() {
            int j;
            int i = 0;
            while (i < this.hidden_layer.length) {
                j = 0;
                while (j < this.input_layer.length) {
                    this.hidden_layer[i].weights[j] = 0.0f;
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < this.output_layer.length) {
                j = 0;
                while (j < this.hidden_layer.length) {
                    this.output_layer[i].weights[j] = 0.0f;
                    ++j;
                }
                ++i;
            }
        }

        public void randomAll() {
            int j;
            int i = 0;
            while (i < this.hidden_layer.length) {
                j = 0;
                while (j < this.input_layer.length) {
                    this.hidden_layer[i].weights[j] = Sketch1.this.random(-1.0f, 1.0f);
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < this.output_layer.length) {
                j = 0;
                while (j < this.hidden_layer.length) {
                    this.output_layer[i].weights[j] = Sketch1.this.random(-1.0f, 1.0f);
                    ++j;
                }
                ++i;
            }
        }

        public void display() {
            Sketch1.this.pushMatrix();
            Sketch1.this.pushStyle();
            Sketch1.this.strokeWeight(1.0f);
            Sketch1.this.translate(Sketch1.this.gameW, Sketch1.this.gameH / 4);
            this.drawCon();
            int i = 0;
            while (i < this.input_layer.length) {
                Sketch1.this.pushMatrix();
                Sketch1.this.translate(this.input_layer[i].x, this.input_layer[i].y);
                this.input_layer[i].display();
                if (i % 2 == 0) {
                    Sketch1.this.text("Left Eye", -50.0f, 5.0f);
                } else {
                    Sketch1.this.text("Right Eye", -50.0f, 5.0f);
                }
                Sketch1.this.popMatrix();
                ++i;
            }
            int j = 0;
            while (j < this.hidden_layer.length) {
                Sketch1.this.pushMatrix();
                Sketch1.this.translate(this.hidden_layer[j].x, this.hidden_layer[j].y);
                this.hidden_layer[j].display();
                Sketch1.this.popMatrix();
                ++j;
            }
            float[] resp = new float[this.output_layer.length];
            float respTotal = 0.0f;
            int k = 0;
            while (k < this.output_layer.length) {
                resp[k] = this.output_layer[k].output;
                respTotal += resp[k] + 1.0f;
                ++k;
            }
            float steering = 0.0f;
            int k2 = 0;
            while (k2 < this.output_layer.length) {
                Sketch1.this.pushMatrix();
                Sketch1.this.translate(this.output_layer[k2].x, this.output_layer[k2].y);
                if (this.output_layer[k2].output < 0.0f) {
                    this.output_layer[k2].output = 0.0f;
                }
                this.output_layer[k2].display();
                Sketch1.this.fill(255);
                Sketch1.nfc((float)((this.output_layer[k2].output + 1.0f) / respTotal * 100.0f), (int)1);
                float steerTemp = this.output_layer[k2].output;
                Sketch1.this.textAlign(0);
                if (k2 % 2 == 0) {
                    steering -= steerTemp / 10.0f;
                    Sketch1.this.text("Left", 30.0f, 5.0f);
                } else {
                    steering += steerTemp / 10.0f;
                    Sketch1.this.text("Right", 30.0f, 5.0f);
                }
                Sketch1.this.textAlign(3);
                Sketch1.this.popMatrix();
                ++k2;
            }
            this.steeringAverage *= 0.6f;
            this.steeringAverage += (steering /= 2.0f) * 0.4f;
            Sketch1.this.gameCar.steer(this.steeringAverage);
            float best = -1.0f;
            int i2 = 0;
            while (i2 < resp.length) {
                if (resp[i2] > best) {
                    best = resp[i2];
                    this.bestIndex = i2;
                }
                ++i2;
            }
            Sketch1.this.stroke(255.0f, 0.0f, 0.0f);
            Sketch1.this.noFill();
            Sketch1.this.popStyle();
            Sketch1.this.popMatrix();
            Sketch1.this.pushMatrix();
            Sketch1.this.fill(255);
            Sketch1.this.translate((float)Sketch1.this.gameW + this.wheelX + 60.0f, Sketch1.this.gameH / 2);
            Sketch1.this.rotate(this.steeringAverage * 20.0f);
            Sketch1.this.ellipse(0.0f, 0.0f, 50.0f, 50.0f);
            Sketch1.this.strokeWeight(2.0f);
            Sketch1.this.stroke(0);
            Sketch1.this.line(0.0f, 0.0f, 25.0f, 0.0f);
            Sketch1.this.popMatrix();
        }

        public void drawCon() {
            PVector midPoint;
            float weight;
            int j;
            int i = 0;
            while (i < this.hidden_layer.length) {
                j = 0;
                while (j < this.input_layer.length) {
                    weight = this.hidden_layer[i].weights[j];
                    Sketch1.this.stroke(255);
                    Sketch1.this.strokeWeight(Sketch1.pow((float)10.0f, (float)Sketch1.abs((float)weight)) / 10.0f);
                    Sketch1.this.line(this.input_layer[j].x, this.input_layer[j].y, this.hidden_layer[i].x, this.hidden_layer[i].y);
                    midPoint = new PVector(this.hidden_layer[i].x - this.input_layer[j].x, this.hidden_layer[i].y - this.input_layer[j].y);
                    midPoint.mult(0.3f);
                    midPoint.add(this.input_layer[j].x, this.input_layer[j].y);
                    this.hidden_layer[i].weights[j] = this.weightDisplay(midPoint.x, midPoint.y, weight);
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < this.output_layer.length) {
                j = 0;
                while (j < this.hidden_layer.length) {
                    weight = this.output_layer[i].weights[j];
                    Sketch1.this.stroke(255);
                    Sketch1.this.strokeWeight(Sketch1.pow((float)10.0f, (float)Sketch1.abs((float)weight)) / 10.0f);
                    Sketch1.this.line(this.hidden_layer[j].x, this.hidden_layer[j].y, this.output_layer[i].x, this.output_layer[i].y);
                    midPoint = new PVector(this.output_layer[i].x - this.hidden_layer[j].x, this.output_layer[i].y - this.hidden_layer[j].y);
                    midPoint.mult(0.6f);
                    midPoint.add(this.hidden_layer[j].x, this.hidden_layer[j].y);
                    this.output_layer[i].weights[j] = this.weightDisplay(midPoint.x, midPoint.y, weight);
                    ++j;
                }
                ++i;
            }
            Sketch1.this.strokeWeight(1.0f);
        }

        public float weightDisplay(float x, float y, float weight) {
            Sketch1.this.noStroke();
            int width = 55;
            int height = 15;
            Sketch1.this.pushMatrix();
            Sketch1.this.translate(x -= (float)(width / 2), y -= (float)(height / 2));
            x += (float)Sketch1.this.gameW;
            y += (float)(Sketch1.this.gameH / 4);
            Sketch1.this.fill(0.0f, 45.0f, 90.0f);
            Sketch1.this.rect(0.0f, 0.0f, 55.0f, 15.0f);
            if ((float)Sketch1.this.mouseX > x && (float)Sketch1.this.mouseX < x + (float)width && (float)Sketch1.this.mouseY > y && (float)Sketch1.this.mouseY < y + (float)height) {
                if (Sketch1.this.mousePressed) {
                    weight = Sketch1.map((float)((float)Sketch1.this.mouseX - x), (float)0.0f, (float)width, (float)-1.0f, (float)1.0f);
                }
                Sketch1.this.fill(0.0f, 116.0f, 217.0f);
                float length = Sketch1.map((float)weight, (float)-1.0f, (float)1.0f, (float)0.0f, (float)55.0f);
                Sketch1.this.rect(0.0f, 0.0f, length, 15.0f);
            }
            Sketch1.this.fill(255);
            Sketch1.this.text("w: " + Sketch1.nfc((float)weight, (int)2), 5.0f, 0.0f, 45.0f, 15.0f);
            Sketch1.this.popMatrix();
            float newWeight = weight;
            return newWeight;
        }
    }

    class Neuron {
        Neuron[] inputs;
        float[] weights;
        float output;
        float error;
        float x;
        float y;
        float diameter = 30.0f;

        Neuron(PVector Pos) {
            this.error = 0.0f;
            this.x = Pos.x;
            this.y = Pos.y;
        }

        Neuron(Neuron[] p_inputs, PVector Pos) {
            this.x = Pos.x;
            this.y = Pos.y;
            this.inputs = new Neuron[p_inputs.length];
            this.weights = new float[p_inputs.length];
            this.error = 0.0f;
            int i = 0;
            while (i < this.inputs.length) {
                this.inputs[i] = p_inputs[i];
                this.weights[i] = Sketch1.this.random(-1.0f, 1.0f);
                ++i;
            }
        }

        public void respond() {
            float input = 0.0f;
            int i = 0;
            while (i < this.inputs.length) {
                input += this.inputs[i].output * this.weights[i];
                ++i;
            }
            this.output = Sketch1.this.lookupSigmoid(input);
            this.error = 0.0f;
        }

        public void setError(float desired) {
            this.error = desired - this.output;
        }

        public void train() {
            float delta = (1.0f - this.output) * (1.0f + this.output) * this.error * Sketch1.this.LEARNING_RATE;
            int i = 0;
            while (i < this.inputs.length) {
                this.inputs[i].error += this.weights[i] * this.error;
                int n = i;
                this.weights[n] = this.weights[n] + this.inputs[i].output * delta;
                ++i;
            }
        }

        public void display() {
            Sketch1.this.stroke(255);
            Sketch1.this.fill(255.0f - 128.0f * (1.0f - this.output));
            Sketch1.this.ellipse(0.0f, 0.0f, this.diameter, this.diameter);
            Sketch1.this.fill(255);
            Sketch1.this.textAlign(3);
            Sketch1.this.text(Sketch1.nfc((float)this.output, (int)1), -2.0f, -this.diameter);
        }

        public float[] getStrength() {
            float ind = 0.0f;
            float str = 0.0f;
            int i = 0;
            while (i < this.weights.length) {
                if (this.weights[i] > str) {
                    ind = i;
                    str = this.weights[i];
                }
                ++i;
            }
            float[] a = new float[]{ind, str};
            return a;
        }
    }
}

