class Car {
  PVector   position = new PVector();
  PVector   velocity = new PVector();
  PVector   rotation = new PVector();
  float     damper;
  float     diameter;
  float     speed;
  float     radius;
  float     eyeA;
  float     eyeB;
  boolean  draging;
  Car(PVector position, PVector direction, float diameter, float speed, float damper)
  {
    this.position = position;
    this.velocity = direction.normalize();
    this.damper = damper; // damper acts like resistance againsts the object, slowing it down over time
    this.rotation = velocity.copy();
    this.speed = speed;
    this.velocity.mult(speed); //velocity is the combination of speed and direction
    this.diameter = diameter;
    this.radius = diameter/2;
  }

  void draw()
  {

    if(!dragNdrop()) {
      velocity.mult(damper);
      velocity.normalize();
      velocity.mult(speed);
      position.add(velocity);
      position = screenWrap(position);
    }
    // visuel stuff
    pushStyle();
    pushMatrix();
    translate(position.x, position.y);
    rotate(rotation.heading());
    noStroke();

    triangle(diameter+3, 0, -diameter, diameter, -diameter, -diameter);
    popMatrix();
    popStyle();

    //
    PVector eye1 = new PVector(20,10);
    eye1.rotate(rotation.heading());
    eye1.add(position.copy());
    PVector eye2 = new PVector(20,-10);
    eye2.rotate(rotation.heading());
    eye2.add(position.copy());
    noStroke();
    ellipse(eye1.x,eye1.y,5,5);
    eyeA = vision(eye2); // inverted, need to fix
    ellipse(eye2.x,eye2.y,5,5);
    eyeB = vision(eye1); // inverted, need to fix
  }

  void updateAngle(float theta) {
    if (!draging) {
      rotation.rotate(theta);
      velocity.rotate(theta);
    }
  }

  float x() {
    return position.x;
  }

  float y() {
    return position.y;
  }

  float vision(PVector pos) {
    int pixel = floor(pos.x) + floor(pos.y)*width;
    if(pixel< width*height && pixel >0) {

      if (pixels[pixel] == color(255)) {
        return(1.0);
        //  println("On track");
      }
    }
    return(-1.0);
  }
  void steerRight() {
    updateAngle(.1);
  }

  void steerLeft() {
    updateAngle(-.1);
  }
  void steer(float angle) {
    updateAngle(angle);
  }

  boolean dragNdrop() {
    if (dist(mouseX,mouseY, position.x,position.y)<=diameter*4) {
          fill(0, 116, 217);
      if (mousePressed == true) {
        position.x = mouseX;
        position.y = mouseY;
        draging = true;
        return true;
      }
    } else {
      fill(0);
    }
    draging = false;
    return false;
  }

  PVector screenWrap(PVector pos) {
    // make sure objects always stay on screen by wraping the game space.
    // check if object is off screen to the right
    if (pos.x > gameW+radius)
    {
      pos.x = 0-radius;
    }
    // check if object is off screen to the left
    if (pos.x < 0-radius)
    {
      pos.x = gameW+radius;
    }
    // check if object is off screen to the bottom
    if (pos.y > gameH+radius)
    {
      pos.y = 0-radius;
    }
    // check if object is off screen to the top
    if (pos.y < 0-radius)
    {
      pos.y = gameH+radius;
    }
    return pos;
  }
}
