/*
 * Decompiled with CFR 0.152.
 */
import controlP5.Button;
import controlP5.ControlP5;
import controlP5.Slider;
import java.util.ArrayList;
import processing.core.PApplet;
import processing.core.PVector;

public class CarLearning
extends PApplet {
    ControlP5 cp5;
    Map gameMap;
    Car gameCar;
    Network neuralnet;
    int gameH;
    int gameW;
    int networkH;
    int networkW;
    ArrayList connec = new ArrayList();
    ArrayList conStr = new ArrayList();
    float LEARNING_RATE = 0.01f;
    float[] g_sigmoid = new float[200];

    public void setup() {
        this.gameH = this.height;
        this.gameW = CarLearning.floor((float)((float)this.width * 0.4f));
        this.networkH = this.height;
        this.networkW = this.width - this.gameW;
        this.setupSigmoid();
        this.gameMap = new Map(CarLearning.floor((float)((float)this.gameW * 0.8f)), CarLearning.floor((float)((float)this.gameH * 0.8f)));
        this.neuralnet = new Network(2, 3, 2);
        PVector position = new PVector((float)(this.width / 2), (float)(this.height / 2));
        PVector direction = new PVector(1.0f, 1.0f);
        this.gameCar = new Car(position, direction, 10.0f, 3.0f, 1.0f);
        this.background(100);
        this.gameMap.draw();
        this.loadPixels();
        this.textSize(10.0f);
        this.cp5 = new ControlP5((PApplet)this);
        ((Button)((Button)this.cp5.addButton("zeroAll").setValue(0.0f).setPosition((float)(this.gameW + 20), 20.0f)).setSize(50, 20)).setCaptionLabel("zero all");
        ((Button)((Button)this.cp5.addButton("randomAll").setValue(100.0f).setPosition((float)(this.gameW + 20), 50.0f)).setSize(50, 20)).setCaptionLabel("randomise");
        ((Slider)this.cp5.addSlider("speed").setPosition(20.0f, 20.0f)).setRange(0.2f, 5.0f).setSize(50, 20).setValue(3.0f);
    }

    public void zeroAll(int theValue) {
        this.neuralnet.zeroAll();
    }

    public void randomAll(int theValue) {
        this.neuralnet.randomAll();
    }

    public void speed(float theValue) {
        this.gameCar.speed = theValue;
    }

    public void draw() {
        this.background(0);
        this.fill(100);
        this.rect(0.0f, 0.0f, this.gameW, this.gameH);
        this.gameMap.draw();
        this.gameCar.draw();
        float[] vision = new float[]{this.gameCar.eyeA, this.gameCar.eyeB};
        this.neuralnet.respond(vision);
        this.neuralnet.display();
    }

    public void setupSigmoid() {
        int i = 0;
        while (i < 200) {
            float x = (float)i / 20.0f - 5.0f;
            this.g_sigmoid[i] = 2.0f / (1.0f + CarLearning.exp((float)(-2.0f * x))) - 1.0f;
            ++i;
        }
    }

    public float lookupSigmoid(float x) {
        return this.g_sigmoid[CarLearning.constrain((int)CarLearning.floor((float)((x + 5.0f) * 20.0f)), (int)0, (int)199)];
    }

    public void settings() {
        this.size(1300, 600);
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"--present", "--window-color=#666666", "--hide-stop", "CarLearning"};
        if (passedArgs != null) {
            PApplet.main((String[])CarLearning.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }

    class Car {
        PVector position = new PVector();
        PVector velocity = new PVector();
        PVector rotation = new PVector();
        float damper;
        float diameter;
        float speed;
        float radius;
        float eyeA;
        float eyeB;
        boolean draging;

        Car(PVector position, PVector direction, float diameter, float speed, float damper) {
            this.position = position;
            this.velocity = direction.normalize();
            this.damper = damper;
            this.rotation = this.velocity.copy();
            this.speed = speed;
            this.velocity.mult(speed);
            this.diameter = diameter;
            this.radius = diameter / 2.0f;
        }

        public void draw() {
            if (!this.dragNdrop()) {
                this.velocity.mult(this.damper);
                this.velocity.normalize();
                this.velocity.mult(this.speed);
                this.position.add(this.velocity);
                this.position = this.screenWrap(this.position);
            }
            CarLearning.this.pushStyle();
            CarLearning.this.pushMatrix();
            CarLearning.this.translate(this.position.x, this.position.y);
            CarLearning.this.rotate(this.rotation.heading());
            CarLearning.this.noStroke();
            CarLearning.this.triangle(this.diameter + 3.0f, 0.0f, -this.diameter, this.diameter, -this.diameter, -this.diameter);
            CarLearning.this.popMatrix();
            CarLearning.this.popStyle();
            PVector eye1 = new PVector(20.0f, 10.0f);
            eye1.rotate(this.rotation.heading());
            eye1.add(this.position.copy());
            PVector eye2 = new PVector(20.0f, -10.0f);
            eye2.rotate(this.rotation.heading());
            eye2.add(this.position.copy());
            CarLearning.this.noStroke();
            CarLearning.this.ellipse(eye1.x, eye1.y, 5.0f, 5.0f);
            this.eyeA = this.vision(eye2);
            CarLearning.this.ellipse(eye2.x, eye2.y, 5.0f, 5.0f);
            this.eyeB = this.vision(eye1);
        }

        public void updateAngle(float theta) {
            if (!this.draging) {
                this.rotation.rotate(theta);
                this.velocity.rotate(theta);
            }
        }

        public float x() {
            return this.position.x;
        }

        public float y() {
            return this.position.y;
        }

        public float vision(PVector pos) {
            int pixel = CarLearning.floor((float)pos.x) + CarLearning.floor((float)pos.y) * CarLearning.this.width;
            if (pixel < CarLearning.this.width * CarLearning.this.height && pixel > 0 && CarLearning.this.pixels[pixel] == CarLearning.this.color(255)) {
                return 1.0f;
            }
            return -1.0f;
        }

        public void steerRight() {
            this.updateAngle(0.1f);
        }

        public void steerLeft() {
            this.updateAngle(-0.1f);
        }

        public void steer(float angle) {
            this.updateAngle(angle);
        }

        public boolean dragNdrop() {
            if (CarLearning.dist((float)CarLearning.this.mouseX, (float)CarLearning.this.mouseY, (float)this.position.x, (float)this.position.y) <= this.diameter * 4.0f) {
                CarLearning.this.fill(0.0f, 116.0f, 217.0f);
                if (CarLearning.this.mousePressed) {
                    this.position.x = CarLearning.this.mouseX;
                    this.position.y = CarLearning.this.mouseY;
                    this.draging = true;
                    return true;
                }
            } else {
                CarLearning.this.fill(0);
            }
            this.draging = false;
            return false;
        }

        public PVector screenWrap(PVector pos) {
            if (pos.x > (float)CarLearning.this.gameW + this.radius) {
                pos.x = 0.0f - this.radius;
            }
            if (pos.x < 0.0f - this.radius) {
                pos.x = (float)CarLearning.this.gameW + this.radius;
            }
            if (pos.y > (float)CarLearning.this.gameH + this.radius) {
                pos.y = 0.0f - this.radius;
            }
            if (pos.y < 0.0f - this.radius) {
                pos.y = (float)CarLearning.this.gameH + this.radius;
            }
            return pos;
        }
    }

    public class Map {
        private ArrayList<PVector> MapPoints = new ArrayList();
        int noPoints = 10;

        Map(int w, int h) {
            int i = 0;
            while (i < this.noPoints) {
                float angle = (float)Math.PI * 2 / (float)this.noPoints;
                PVector point = new PVector(CarLearning.sin((float)(angle *= (float)i)), CarLearning.cos((float)angle));
                point.mult((float)w * 0.4f + CarLearning.this.random(-40.0f, 40.0f));
                point.add((float)(CarLearning.this.gameW / 2), (float)(CarLearning.this.gameH / 2));
                this.MapPoints.add(point);
                ++i;
            }
        }

        public void draw() {
            CarLearning.this.noFill();
            CarLearning.this.strokeWeight(50.0f);
            CarLearning.this.stroke(255);
            CarLearning.this.beginShape();
            PVector point = this.MapPoints.get(0);
            CarLearning.this.curveVertex(point.x, point.y);
            int i = 0;
            while (i < this.MapPoints.size()) {
                point = this.MapPoints.get(i);
                CarLearning.this.curveVertex(point.x, point.y);
                ++i;
            }
            point = this.MapPoints.get(0);
            CarLearning.this.curveVertex(point.x, point.y);
            point = this.MapPoints.get(1);
            CarLearning.this.curveVertex(point.x, point.y);
            CarLearning.this.endShape(2);
        }
    }

    class Network {
        Neuron[] input_layer;
        Neuron[] hidden_layer;
        Neuron[] output_layer;
        int w;
        int h;
        float wheelX = 0.0f;
        float wheelY = 0.0f;
        int bestIndex = 0;
        float steeringAverage = 0.0f;

        Network(int inputs, int hidden, int outputs) {
            PVector pos;
            this.input_layer = new Neuron[inputs];
            this.hidden_layer = new Neuron[hidden];
            this.output_layer = new Neuron[outputs];
            int i = 0;
            while (i < this.input_layer.length) {
                pos = new PVector((float)CarLearning.this.networkW * 0.15f, (float)(i * (CarLearning.this.networkH / 2)));
                this.input_layer[i] = new Neuron(pos);
                ++i;
            }
            int j = 0;
            while (j < this.hidden_layer.length) {
                pos = new PVector((float)CarLearning.this.networkW * 0.5f, (float)(j * (CarLearning.this.networkH / 4)));
                this.hidden_layer[j] = new Neuron(this.input_layer, pos);
                ++j;
            }
            int k = 0;
            while (k < this.output_layer.length) {
                pos = new PVector((float)CarLearning.this.networkW * 0.85f, (float)(k * (CarLearning.this.networkH / 2)));
                this.output_layer[k] = new Neuron(this.hidden_layer, pos);
                ++k;
            }
            this.wheelX = (float)CarLearning.this.networkW * 0.85f;
            this.wheelY = CarLearning.this.networkH / 2;
        }

        public void respond(float[] inputs) {
            int i = 0;
            while (i < this.input_layer.length) {
                this.input_layer[i].output = inputs[i];
                ++i;
            }
            int j = 0;
            while (j < this.hidden_layer.length) {
                this.hidden_layer[j].respond();
                ++j;
            }
            int k = 0;
            while (k < this.output_layer.length) {
                this.output_layer[k].respond();
                ++k;
            }
        }

        public void zeroAll() {
            int j;
            int i = 0;
            while (i < this.hidden_layer.length) {
                j = 0;
                while (j < this.input_layer.length) {
                    this.hidden_layer[i].weights[j] = 0.0f;
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < this.output_layer.length) {
                j = 0;
                while (j < this.hidden_layer.length) {
                    this.output_layer[i].weights[j] = 0.0f;
                    ++j;
                }
                ++i;
            }
        }

        public void randomAll() {
            int j;
            int i = 0;
            while (i < this.hidden_layer.length) {
                j = 0;
                while (j < this.input_layer.length) {
                    this.hidden_layer[i].weights[j] = CarLearning.this.random(-1.0f, 1.0f);
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < this.output_layer.length) {
                j = 0;
                while (j < this.hidden_layer.length) {
                    this.output_layer[i].weights[j] = CarLearning.this.random(-1.0f, 1.0f);
                    ++j;
                }
                ++i;
            }
        }

        public void display() {
            CarLearning.this.pushMatrix();
            CarLearning.this.pushStyle();
            CarLearning.this.strokeWeight(1.0f);
            CarLearning.this.translate(CarLearning.this.gameW, CarLearning.this.gameH / 4);
            this.drawCon();
            int i = 0;
            while (i < this.input_layer.length) {
                CarLearning.this.pushMatrix();
                CarLearning.this.translate(this.input_layer[i].x, this.input_layer[i].y);
                this.input_layer[i].display();
                if (i % 2 == 0) {
                    CarLearning.this.text("Left Eye", -50.0f, 5.0f);
                } else {
                    CarLearning.this.text("Right Eye", -50.0f, 5.0f);
                }
                CarLearning.this.popMatrix();
                ++i;
            }
            int j = 0;
            while (j < this.hidden_layer.length) {
                CarLearning.this.pushMatrix();
                CarLearning.this.translate(this.hidden_layer[j].x, this.hidden_layer[j].y);
                this.hidden_layer[j].display();
                CarLearning.this.popMatrix();
                ++j;
            }
            float[] resp = new float[this.output_layer.length];
            float respTotal = 0.0f;
            int k = 0;
            while (k < this.output_layer.length) {
                resp[k] = this.output_layer[k].output;
                respTotal += resp[k] + 1.0f;
                ++k;
            }
            float steering = 0.0f;
            int k2 = 0;
            while (k2 < this.output_layer.length) {
                CarLearning.this.pushMatrix();
                CarLearning.this.translate(this.output_layer[k2].x, this.output_layer[k2].y);
                if (this.output_layer[k2].output < 0.0f) {
                    this.output_layer[k2].output = 0.0f;
                }
                this.output_layer[k2].display();
                CarLearning.this.fill(255);
                CarLearning.nfc((float)((this.output_layer[k2].output + 1.0f) / respTotal * 100.0f), (int)1);
                float steerTemp = this.output_layer[k2].output;
                CarLearning.this.textAlign(0);
                if (k2 % 2 == 0) {
                    steering -= steerTemp / 10.0f;
                    CarLearning.this.text("Left", 30.0f, 5.0f);
                } else {
                    steering += steerTemp / 10.0f;
                    CarLearning.this.text("Right", 30.0f, 5.0f);
                }
                CarLearning.this.textAlign(3);
                CarLearning.this.popMatrix();
                ++k2;
            }
            this.steeringAverage *= 0.6f;
            this.steeringAverage += (steering /= 2.0f) * 0.4f;
            CarLearning.this.gameCar.steer(this.steeringAverage);
            float best = -1.0f;
            int i2 = 0;
            while (i2 < resp.length) {
                if (resp[i2] > best) {
                    best = resp[i2];
                    this.bestIndex = i2;
                }
                ++i2;
            }
            CarLearning.this.stroke(255.0f, 0.0f, 0.0f);
            CarLearning.this.noFill();
            CarLearning.this.popStyle();
            CarLearning.this.popMatrix();
            CarLearning.this.pushMatrix();
            CarLearning.this.fill(255);
            CarLearning.this.translate((float)CarLearning.this.gameW + this.wheelX + 60.0f, CarLearning.this.gameH / 2);
            CarLearning.this.rotate(this.steeringAverage * 20.0f);
            CarLearning.this.ellipse(0.0f, 0.0f, 50.0f, 50.0f);
            CarLearning.this.strokeWeight(2.0f);
            CarLearning.this.stroke(0);
            CarLearning.this.line(0.0f, 0.0f, 25.0f, 0.0f);
            CarLearning.this.popMatrix();
        }

        public void drawCon() {
            PVector midPoint;
            float weight;
            int j;
            int i = 0;
            while (i < this.hidden_layer.length) {
                j = 0;
                while (j < this.input_layer.length) {
                    weight = this.hidden_layer[i].weights[j];
                    CarLearning.this.stroke(255);
                    CarLearning.this.strokeWeight(CarLearning.pow((float)10.0f, (float)CarLearning.abs((float)weight)) / 10.0f);
                    CarLearning.this.line(this.input_layer[j].x, this.input_layer[j].y, this.hidden_layer[i].x, this.hidden_layer[i].y);
                    midPoint = new PVector(this.hidden_layer[i].x - this.input_layer[j].x, this.hidden_layer[i].y - this.input_layer[j].y);
                    midPoint.mult(0.3f);
                    midPoint.add(this.input_layer[j].x, this.input_layer[j].y);
                    this.hidden_layer[i].weights[j] = this.weightDisplay(midPoint.x, midPoint.y, weight);
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < this.output_layer.length) {
                j = 0;
                while (j < this.hidden_layer.length) {
                    weight = this.output_layer[i].weights[j];
                    CarLearning.this.stroke(255);
                    CarLearning.this.strokeWeight(CarLearning.pow((float)10.0f, (float)CarLearning.abs((float)weight)) / 10.0f);
                    CarLearning.this.line(this.hidden_layer[j].x, this.hidden_layer[j].y, this.output_layer[i].x, this.output_layer[i].y);
                    midPoint = new PVector(this.output_layer[i].x - this.hidden_layer[j].x, this.output_layer[i].y - this.hidden_layer[j].y);
                    midPoint.mult(0.6f);
                    midPoint.add(this.hidden_layer[j].x, this.hidden_layer[j].y);
                    this.output_layer[i].weights[j] = this.weightDisplay(midPoint.x, midPoint.y, weight);
                    ++j;
                }
                ++i;
            }
            CarLearning.this.strokeWeight(1.0f);
        }

        public float weightDisplay(float x, float y, float weight) {
            CarLearning.this.noStroke();
            int width = 55;
            int height = 15;
            CarLearning.this.pushMatrix();
            CarLearning.this.translate(x -= (float)(width / 2), y -= (float)(height / 2));
            x += (float)CarLearning.this.gameW;
            y += (float)(CarLearning.this.gameH / 4);
            CarLearning.this.fill(0.0f, 45.0f, 90.0f);
            CarLearning.this.rect(0.0f, 0.0f, 55.0f, 15.0f);
            if ((float)CarLearning.this.mouseX > x && (float)CarLearning.this.mouseX < x + (float)width && (float)CarLearning.this.mouseY > y && (float)CarLearning.this.mouseY < y + (float)height) {
                if (CarLearning.this.mousePressed) {
                    weight = CarLearning.map((float)((float)CarLearning.this.mouseX - x), (float)0.0f, (float)width, (float)-1.0f, (float)1.0f);
                }
                CarLearning.this.fill(0.0f, 116.0f, 217.0f);
                float length = CarLearning.map((float)weight, (float)-1.0f, (float)1.0f, (float)0.0f, (float)55.0f);
                CarLearning.this.rect(0.0f, 0.0f, length, 15.0f);
            }
            CarLearning.this.fill(255);
            CarLearning.this.text("w: " + CarLearning.nfc((float)weight, (int)2), 5.0f, 0.0f, 45.0f, 15.0f);
            CarLearning.this.popMatrix();
            float newWeight = weight;
            return newWeight;
        }
    }

    class Neuron {
        Neuron[] inputs;
        float[] weights;
        float output;
        float error;
        float x;
        float y;
        float diameter = 30.0f;

        Neuron(PVector Pos) {
            this.error = 0.0f;
            this.x = Pos.x;
            this.y = Pos.y;
        }

        Neuron(Neuron[] p_inputs, PVector Pos) {
            this.x = Pos.x;
            this.y = Pos.y;
            this.inputs = new Neuron[p_inputs.length];
            this.weights = new float[p_inputs.length];
            this.error = 0.0f;
            int i = 0;
            while (i < this.inputs.length) {
                this.inputs[i] = p_inputs[i];
                this.weights[i] = CarLearning.this.random(-1.0f, 1.0f);
                ++i;
            }
        }

        public void respond() {
            float input = 0.0f;
            int i = 0;
            while (i < this.inputs.length) {
                input += this.inputs[i].output * this.weights[i];
                ++i;
            }
            this.output = CarLearning.this.lookupSigmoid(input);
            this.error = 0.0f;
        }

        public void setError(float desired) {
            this.error = desired - this.output;
        }

        public void train() {
            float delta = (1.0f - this.output) * (1.0f + this.output) * this.error * CarLearning.this.LEARNING_RATE;
            int i = 0;
            while (i < this.inputs.length) {
                this.inputs[i].error += this.weights[i] * this.error;
                int n = i;
                this.weights[n] = this.weights[n] + this.inputs[i].output * delta;
                ++i;
            }
        }

        public void display() {
            CarLearning.this.stroke(255);
            CarLearning.this.fill(255.0f - 128.0f * (1.0f - this.output));
            CarLearning.this.ellipse(0.0f, 0.0f, this.diameter, this.diameter);
            CarLearning.this.fill(255);
            CarLearning.this.textAlign(3);
            CarLearning.this.text(CarLearning.nfc((float)this.output, (int)1), -2.0f, -this.diameter);
        }

        public float[] getStrength() {
            float ind = 0.0f;
            float str = 0.0f;
            int i = 0;
            while (i < this.weights.length) {
                if (this.weights[i] > str) {
                    ind = i;
                    str = this.weights[i];
                }
                ++i;
            }
            float[] a = new float[]{ind, str};
            return a;
        }
    }
}

