/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.cache;

import com.sun.deploy.resources.ResourceManager;
import java.text.MessageFormat;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import sun.plugin.cache.JarCacheVersionException;

public class FileVersion {
    private String strVersion;
    private long longVersion;
    private static final int VERSION_DIGITS = 4;
    private static final int VERSION_DIGITS_BITSIZE = 16;
    private static final int VERSION_DIGITS_BYTESIZE = 4;
    private static final int VERSION_DIGITS_RADIX = 16;
    public static final String defStrVersion = "x.x.x.x";
    public static final int defIntVersion = 0;
    public static final String regEx = "\\p{XDigit}{1,4}\\.\\p{XDigit}{1,4}\\.\\p{XDigit}{1,4}\\.\\p{XDigit}{1,4}";

    public FileVersion() {
        this.strVersion = defStrVersion;
        this.longVersion = 0L;
    }

    public FileVersion(String string) throws JarCacheVersionException {
        this.strVersion = string;
        this.longVersion = FileVersion.convertToLong(string);
    }

    public FileVersion(long l) {
        this.strVersion = FileVersion.convertToString(l);
        this.longVersion = l;
    }

    public void setVersion(long l) {
        if (l > 0L) {
            this.longVersion = l;
            this.strVersion = FileVersion.convertToString(l);
        }
    }

    public void setVersion(String string) throws JarCacheVersionException {
        if (string != null) {
            this.strVersion = string;
            this.longVersion = FileVersion.convertToLong(string);
        }
    }

    public long getVersionAsLong() {
        return this.longVersion;
    }

    public String getVersionAsString() {
        return this.strVersion;
    }

    public boolean isUpToDate(FileVersion fileVersion) {
        return !this.strVersion.equals(defStrVersion) && this.longVersion >= fileVersion.longVersion;
    }

    public static long convertToLong(String string) throws JarCacheVersionException {
        long l = 0L;
        if (!Pattern.matches(regEx, string)) {
            MessageFormat messageFormat = new MessageFormat(ResourceManager.getMessage((String)"cache.version_format_error"));
            throw new JarCacheVersionException(messageFormat.format(new Object[]{string}));
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".", false);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            l <<= 16;
            l += (long)Integer.parseInt(string2, 16);
        }
        return l;
    }

    public static String convertToString(long l) {
        String string = "";
        long l2 = l;
        for (int i = 0; i < 4; ++i) {
            long l3 = l2 >> 48 & 0xFFFFL;
            l2 <<= 16;
            string = string + Long.toString(l3, 16);
            string = string + (i != 3 ? "." : "");
        }
        return string;
    }

    public static String getMessage(String string) {
        return ResourceManager.getMessage((String)string);
    }
}

