
ArrayList<ForcePoint>  forcePointList = new ArrayList<ForcePoint>();
int                     borderDist = 30;
int                     gridX = 40;
int                     gridY = 40;

void setup()
{
  size(600,600);
  
  // setup the grid
  float stepX = (float)(width - borderDist * 2) / (gridX - 1);
  float stepY = (float)(height - borderDist * 2) / (gridY - 1);
  
  for(int x=0;x < gridX;x++)
  {
    for(int y=0;y < gridY;y++)
    {
      forcePointList.add(new ForcePoint((int)(stepX * x + borderDist),(int)(stepY * y + borderDist),100,0.99f));      
    } 
  }
  
}

void draw()
{
  background(0);
  
  ForcePoint forcePoint; 
  
  for(int i=0;i < forcePointList.size();i++)
  {
    forcePoint = forcePointList.get(i);  
    
    forcePoint.update();
    forcePoint.draw();
  }
}

void mouseDragged()
{
  ForcePoint forcePoint; 
  
  for(int i=0;i < forcePointList.size();i++)
  {
    forcePoint = forcePointList.get(i);  
    
    forcePoint.setInput(mouseX,mouseY);
  }
}

