
ArrayList<ForcePoint>  forcePointList = new ArrayList<ForcePoint>();
int                     borderDist = 30;
int                     gridX = 30;
int                     gridY = 30;

void setup()
{
  size(600,600);
  
  // setup the grid
  float stepX = (float)(width - borderDist * 2) / (gridX - 1);
  float stepY = (float)(height - borderDist * 2) / (gridY - 1);
  
  for(int x=0;x < gridX;x++)
  {
    for(int y=0;y < gridY;y++)
    {
      forcePointList.add(new ForcePointTrail((int)(stepX * x + borderDist),(int)(stepY * y + borderDist),200,0.593f));      
    } 
  }
  
}

void draw()
{
  background(0);
  
  updateForceField();
  
  ForcePoint forcePoint; 
  for(int i=0;i < forcePointList.size();i++)
  {
    forcePoint = forcePointList.get(i);  
    
    forcePoint.update();
    forcePoint.draw();
  }
}

void updateForceField()
{  
  ForcePoint forcePoint; 
  
  for(int i=0;i < forcePointList.size();i++)
  {
    forcePoint = forcePointList.get(i);  
    
    if(mousePressed &&  mouseButton == LEFT)
      forcePoint.setInput(mouseX,mouseY,0);
    else if(mousePressed &&  mouseButton == RIGHT)
      forcePoint.setInput(mouseX,mouseY,1);
  }
}

