class Satellite {
  boolean   display;
  PVector   position = new PVector();
  PVector   velocity = new PVector();
  PVector   rotation = new PVector();
  float     damper;
  float     diameter;
  float     speed;
  float     radius;


  Satellite(PVector position, PVector direction, float diameter, float speed, float damper)
  {
     this.position = position;
     this.velocity = direction.normalize();
     this.damper = damper; // damper acts like resistance againsts the object, slowing it down over time
     this.rotation = velocity.copy();
     this.speed = speed;
     this.velocity.mult(speed); //velocity is the combination of speed and direction 
     this.diameter = diameter;
     this.radius = diameter/2;
     this.display = true;
  }

  void display()
  {
    if (display) {
      velocity.mult(damper);
      position.add(velocity);
      screenWrap();
    }
  }

  void collision() {
    display = false;
  };

  void screenWrap() {
    // make sure satellites always stay on screen by wraping the game space.
    PVector   newPosition = new PVector();
    newPosition = position.copy();

    if (newPosition.x > width+radius)
    {
      newPosition.x = 0-radius;
    }

    if (newPosition.x < 0-radius)
    {
      newPosition.x = width+radius;
    }

    if (newPosition.y > height+radius)
    {
      newPosition.y = 0-radius;
    }

    if (newPosition.y < 0-radius)
    {
      newPosition.y = height+radius;
    }
    position = newPosition.copy();
  }
}