// game objects and lists  //<>// //<>//
Ship myShip;
ArrayList<Asteroid> asteroids;
ArrayList<Bullet> bullets;
// game variables  
boolean keyLeft = false;
boolean keyRight = false;
boolean keyUp = false;
final int startScreen = 0;
final int playingGame = 1;
final int gameOver = 2;
final int gameWon = 3;
int Status = 0;

void setup()
{
  size(600, 600); // can be replaced with fullScreen() 
  setupGame();
  noStroke();
}

void draw() {
  switch(Status) {
  case startScreen:
    drawStartScreen();
    break;
  case playingGame:
    drawGame();
    break;
  case gameOver:
    drawGameOverScreen();
    break;
  case gameWon:
    drawGameWonScreen();
    break;
  }
}


void setupGame()
{
  //creat instances of all the game objects 
  PVector shipPosition = new PVector(300, 300);
  PVector shipDirection = new PVector(1, 1);
  myShip = new Ship(shipPosition, shipDirection, 40, .1, .993);
  bullets = new ArrayList<Bullet>();
  asteroids = new ArrayList<Asteroid>();
  // randomly position asteroids around the game 
  for (int i = 0; i < 6; i++) {
    PVector asteroidsPosition = new PVector(random(width), random(height));
    float minimumDistance =  asteroidsPosition.dist(shipPosition);
    // check that the game always starts with a minimum distance between player and asteroids.
    while (minimumDistance <= 300) {
      asteroidsPosition.set(random(width), random(height));
      minimumDistance =  asteroidsPosition.dist(shipPosition);  
    }
    PVector asteroidsDirection = new PVector(random(1), random(1));
    float diameter = random(30)+20;
    float speed = 2;
    float damper = 1;
    asteroids.add(new Asteroid(asteroidsPosition, asteroidsDirection, diameter, speed, damper));
  }
}


//*************
// game screens
//*************

void drawStartScreen() {
  background(50);
  textAlign(CENTER);
  textSize(40);
  fill(200, 10, 10);
  text("ASTEROID \n press space to start ", width/2, height/2);
}

void drawGameOverScreen() {
  background(50);
  textAlign(CENTER);
  textSize(40);
  fill(200, 10, 10);
  text("GAME OVER", width/2, height/2);
}

void drawGameWonScreen() {
  background(50);
  textAlign(CENTER);
  textSize(40);
  fill(200, 10, 10);
  text("You won!", width/2, height/2);
}

void drawGame() {

  background(50);
  // call the display function on all objects 
  myShip.display();
  for (Asteroid object : asteroids) {
    object.display();
  }
  for (Bullet object : bullets) {
    object.display();
  }
  // key control
  if (keyUp) {
    myShip.updateSpeed();
  }
  if (keyRight) {
    myShip.updateAngle(.2);
  }
  if (keyLeft) {
    myShip.updateAngle(-.2);
  }
  collisionDetection();
}


//*************
// Collision Detection 
//*************

void collisionDetection() {
  // if all the asteroids are gone, then game has been won
  if (asteroids.size() == 0) {
    Status = gameWon;
  }
  // check ship against asteroids
  for (int i = 0; i < asteroids.size(); i++) {
    Asteroid asteroid  = asteroids.get(i);
    boolean collision = circleColDet(asteroid.position, asteroid.radius, myShip.position, myShip.radius); 
    if (collision) {
      asteroid.collision();
      myShip.collision();
      pushStyle();
      fill(0, 200, 10);
      ellipse(myShip.position.x, myShip.position.y, 100, 100);
      Status = gameOver;
      popStyle();
    }
  }
  // check bullets againts asteroids
  for (int i = 0; i < bullets.size(); i++) {
    Bullet object1  = bullets.get(i);
    if (object1.display == false) {
      //remove bullets if they are off screen 
      bullets.remove(i);
      break;
    }
    for (int j = 0; j < asteroids.size(); j++) {
      Asteroid object2  = asteroids.get(j);
      boolean collision = circleColDet(object1.position, object1.radius, object2.position, object2.radius); 
      if (collision) {
        pushStyle();
        fill(0, 200, 10);
        ellipse(object2.position.x, object2.position.y, 60, 60);
        popStyle();
        object1.collision();
        object2.collision();
        bullets.remove(i);
        asteroids.remove(j);
      }
    }
  };
};

// Circle Collision Detection
boolean circleColDet(PVector object1, float radius1, PVector object2, float radius2) {
  float distance = object1.dist(object2);
  if (distance < radius1 + radius2) {
    return true;
  } else {
    return false;
  }
}

void shoot() {
  bullets.add(new Bullet(myShip.position.copy(), myShip.rotation.copy()));
}

//*************
// game events
//*************
void keyPressed() {
  if (key == CODED) {
    if (keyCode == UP) {
      keyUp = true;
    } 
    if (keyCode == LEFT) {
      keyLeft = true;
    } 
    if (keyCode == RIGHT) {
      keyRight = true;
    }
  }
} 

void keyReleased() {
  if (keyCode == UP) {
    keyUp = false;
  } 
  if (keyCode == LEFT) {
    keyLeft = false;
  } 
  if (keyCode == RIGHT) {
    keyRight = false;
  }
  if (key == ' ') {
    if (Status == playingGame) {
      shoot();
    } else {
      setupGame();
      Status = playingGame;
    }
  }
}