/* --------------------------------------------------------------------------
 * Brick
 * --------------------------------------------------------------------------
 * prog:  Max Rheiner 
 * date:  26/09/2012 (m/d/y)
 * ----------------------------------------------------------------------------
 */

class Brick
{
  final static int  HIT_NO     = 0;
  final static int  HIT_LEFT   = 1;
  final static int  HIT_RIGTH  = 2;
  final static int  HIT_TOP    = 3;
  final static int  HIT_BOTTOM = 4;

  PVector   _pos;
  float     _w;
  float     _h;

  // konstruktor
  Brick(int x, int y, int w, int h)
  {
    _pos = new PVector(x, y);

    _w = w;
    _h = h;
  }

  // zeichnet den ball
  void draw()
  {
    pushStyle();
    rectMode(CENTER);
    fill(255);
    rect(_pos.x, _pos.y, _w, _h);
    popStyle();
  }

  PVector cornerLT()
  {
    return new PVector(_pos.x - _w / 2, _pos.y - _h / 2);
  }

  PVector cornerRT()
  {
    return new PVector(_pos.x + _w / 2, _pos.y - _h / 2);
  }

  PVector cornerLB()  
  {
    return new PVector(_pos.x - _w / 2, _pos.y + _h / 2);
  }

  PVector cornerRB()
  {
    return new PVector(_pos.x + _w / 2, _pos.y + _h / 2);
  }

  int checkCollision(float x, float y, float r, PVector dirObj,PVector hitPos)
  {
    if(x + r >= _pos.x - _w/2  && x -r <= _pos.x + _w/2 &&
       y + r >= _pos.y - _h/2 && y - r <= _pos.y + _h/2)
    {
      // teste welche kannte getroffen wurde
      PVector dir = dirObj.get();
      dir.normalize();   
      
      // berechne eine linie
      PVector pObj = PVector.add(new PVector(x, y), PVector.mult(dir, r));
      PVector pObjPrev = PVector.sub(new PVector(x, y), PVector.mult(dir, 50));

      PVector lt = cornerLT();
      PVector rt = cornerRT();
      PVector lb = cornerLB();
      PVector rb = cornerRB();

      PVector vecTop     = segIntersection(pObjPrev.x, pObjPrev.y, pObj.x, pObj.y, 
                                             lt.x, lt.y, rt.x, rt.y);
      PVector vecBottom  = segIntersection(pObjPrev.x, pObjPrev.y, pObj.x, pObj.y, 
                                            lb.x, lb.y, rb.x, rb.y);
      PVector vecLeft    = segIntersection(pObjPrev.x, pObjPrev.y, pObj.x, pObj.y, 
                                             lt.x, lt.y, lb.x, lb.y);
      PVector vecRight   = segIntersection(pObjPrev.x, pObjPrev.y, pObj.x, pObj.y, 
                                            rt.x, rt.y, rb.x, rb.y);
      
      // teste kante oben
      if(vecTop != null)
      {
        hitPos.set(vecTop);
        return HIT_TOP;
      }                
      else if(vecBottom != null)
      {
        hitPos.set(vecBottom);
        return HIT_BOTTOM;
      }                      
      else if (vecLeft != null)
      {
        hitPos.set(vecLeft);
        return HIT_LEFT;
      }                      
      else if (vecRight != null)
      {
        hitPos.set(vecRight);
        return HIT_RIGTH;
      }                      
      else
        return HIT_NO;

    }
    return HIT_NO;
  }
  
  
}

// checkout http://wiki.processing.org/w/Line-Line_intersection
PVector lineIntersection(float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4)
{
  float bx = x2 - x1;
  float by = y2 - y1;
  float dx = x4 - x3;
  float dy = y4 - y3; 
  float b_dot_d_perp = bx*dy - by*dx;
  if (b_dot_d_perp == 0) {
    return null;
  }
  float cx = x3-x1; 
  float cy = y3-y1;
  float t = (cx*dy - cy*dx) / b_dot_d_perp; 

  return new PVector(x1+t*bx, y1+t*by);
}


PVector segIntersection(float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4) 
{ 
  float bx = x2 - x1; 
  float by = y2 - y1; 
  float dx = x4 - x3; 
  float dy = y4 - y3;
  float b_dot_d_perp = bx * dy - by * dx;
  if(b_dot_d_perp == 0) {
    return null;
  }
  float cx = x3 - x1;
  float cy = y3 - y1;
  float t = (cx * dy - cy * dx) / b_dot_d_perp;
  if(t < 0 || t > 1) {
    return null;
  }
  float u = (cx * by - cy * bx) / b_dot_d_perp;
  if(u < 0 || u > 1) { 
    return null;
  }
  return new PVector(x1+t*bx, y1+t*by);
}
