// https://p5js.org/examples/input-easing.html

let x = 1;
let y = 1;
let easing = 0.05;

function setup() {
    const viewPort = getViewPortSize();
    createCanvas(viewPort.x, viewPort.y);
}

function draw() {
    background(237, 34, 93);
    let targetX = mouseX;
    let dx = targetX - x;
    x += dx * easing;

    let targetY = mouseY;
    let dy = targetY - y;
    y += dy * easing;

    noStroke();
    ellipse(x, y, 66, 66);

    stroke(255);
    line(x, y, width / 2, height / 2);
}

// this is called when resizing the viewport
function windowResized() {
    const viewPort = getViewPortSize();
    resizeCanvas(viewPort.x, viewPort.y);
}

// gets the current viewport size
function getViewPortSize() {
    const vw = Math.max(document.documentElement.clientWidth, window.innerWidth || 0);
    const vh = Math.max(document.documentElement.clientHeight, window.innerHeight || 0);
    return createVector(vw, vh);
}
