const express = require('express');
const socket = require('socket.io');

// App Setup
const app = express();
const port = 8080;

const server = app.listen(port, function(){

	console.log('listening to requests on port 8080');
});


// Static Files
app.use(express.static('public'));

// Socket Setup
const io = socket(server);


// Function Upon Connection
io.on('connection', function(socket){
	
	var socketID = socket.id;
	console.log('new client connection id : ', socketID);

	// Emit Connected message to all the sockets
	io.sockets.emit('connected', {
		id: socketID
	});

	// Handle The Location Events
	socket.on('location',function(data){
		io.sockets.emit('location',data);
		console.log(data);
	});

	// Upon disconnect 
	socket.on('disconnect', function(){
		console.log('disconnected id : ' , socketID)
	});


	

});


