int gridWidth = 100; 
int gridHeight = 100; 
float pointDistX = 5; 
float pointDistY = 5; 
ArrayList<Integer> imageGreyScaleList = new ArrayList<Integer>();
PImage baseImage;  

void setup() {
  size(700, 700);
  smooth();
  baseImage = loadImage("data/image.jpg");
  baseImage.loadPixels();
  int loc;
  for (int i = 0; i < baseImage.width; i++) {
    for (int j = 0; j < baseImage.height; j++) {  
      loc = i + j*baseImage.width;
      println(baseImage.pixels[loc]);
      color pixel = baseImage.pixels[loc];
      int greyScale = floor(red(pixel)+green(pixel)+blue(pixel)/3);
      imageGreyScaleList.add(greyScale);
    }
  }
};

void draw() {
  background(255);
  pushMatrix(); 
  // translate graphic to the center of the screen  
  translate((width-(pointDistX*gridWidth))/2, (height-(pointDistY*gridHeight))/2);
  int loc;
  for (int i = 0; i<gridHeight; i++ ) {
    beginShape();
    for (int j = 0; j<gridWidth; j++) {
      loc = i + j*baseImage.width;
      float posX =  j*pointDistX;
      float posY =  i*pointDistY+map(imageGreyScaleList.get(loc), 0, 255, 0, 10); // offset y coordinate based on the pixels colour
      curveVertex(posX, posY);
    };
    endShape();
  };
  popMatrix();
};